/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.logging.Args;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.results.AutoCloseableIterator;
import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.driver.statement.QueryResult;
import com.palantir.foundry.sql.jdbc.base.AbstractFoundryJdbcStatement;
import com.palantir.foundry.sql.jdbc.results.FoundryJdbcResultSet;
import com.palantir.foundry.sql.jdbc.results.FoundryJdbcResultSetMetaData;
import com.palantir.logsafe.SafeArg;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

public abstract class FoundryJdbcBaseStatement
implements AbstractFoundryJdbcStatement {
    private static final Logger log = DriverLoggerFactory.getLogger(FoundryJdbcBaseStatement.class);
    private final Supplier<AuthHeader> authHeader;
    private final Connection connection;
    private final QueryManager queryManager;
    private Optional<QueryId> currentQuery = Optional.empty();
    private Optional<ResultSet> currentResultSet = Optional.empty();
    private boolean closed = false;
    private int maxRows = 0;

    protected FoundryJdbcBaseStatement(Supplier<AuthHeader> authHeader, Connection connection, QueryManager queryManager) {
        this.authHeader = authHeader;
        this.connection = connection;
        this.queryManager = queryManager;
    }

    protected final ResultSet executeSql(String sql, SqlDialect sqlDialect, Parameters parameters) throws SQLException {
        this.assertNotClosed();
        log.info("Executing query");
        QueryResult results = this.queryManager.query(this.authHeader, sql, sqlDialect, parameters);
        this.currentQuery = Optional.of(results.queryId());
        log.info("Got results. Row count: {}", (Object)SafeArg.of("rowCount", results.rowCount()));
        AutoCloseableIterator<DriverRow> rows = results.rowIterator();
        AutoCloseableIterator<DriverRow> limitedRows = this.getMaxRows() <= 0 ? rows : AutoCloseableIterator.limit(rows, this.getMaxRows());
        this.currentResultSet = Optional.of(FoundryJdbcResultSet.of(this, results.columnTypes(), limitedRows));
        return this.currentResultSet.get();
    }

    protected final FoundryJdbcResultSetMetaData describeSql(String sql, SqlDialect sqlDialect, Parameters parameters) throws SQLException {
        this.assertNotClosed();
        log.info("Describing query");
        List<FoundryFieldSchema> schema = this.queryManager.describeQuery(this.authHeader, sql, sqlDialect, parameters);
        log.info("Got metadata. Column count: {}", (Object)SafeArg.of("columnCount", schema.size()));
        return new FoundryJdbcResultSetMetaData(schema);
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        this.assertNotClosed();
        return this.currentResultSet.orElse(null);
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        this.assertNotClosed();
        if (this.currentResultSet.isPresent()) {
            this.currentResultSet.get().close();
        }
        return false;
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        this.assertNotClosed();
        if ((current == 1 || current == 3) && this.currentResultSet.isPresent()) {
            this.currentResultSet.get().close();
        }
        return false;
    }

    @Override
    public final int getMaxRows() throws SQLException {
        this.assertNotClosed();
        return this.maxRows;
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.assertNotClosed();
        if (max < 0) {
            throw new SQLException("Max rows should be greater than or equal to 0");
        }
        this.maxRows = max;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        this.assertNotClosed();
        return this.connection;
    }

    @Override
    public final void cancel() {
        if (this.currentQuery.isPresent()) {
            log.info("Cancelling query: {}", (Object)Args.queryId(this.currentQuery.get()));
            this.queryManager.cancel(this.authHeader, this.currentQuery.get());
        }
    }

    @Override
    public final void close() {
        this.closed = true;
        if (this.currentQuery.isPresent()) {
            log.info("Closing statement for query: {}", (Object)Args.queryId(this.currentQuery.get()));
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    protected final void assertNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
    }
}

