/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.auth.TokenSupplier;
import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import com.palantir.foundry.sql.driver.logging.Args;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.jdbc.FoundryJdbcDatabaseMetadata;
import com.palantir.foundry.sql.jdbc.FoundryJdbcPreparedStatement;
import com.palantir.foundry.sql.jdbc.FoundryJdbcStatement;
import com.palantir.foundry.sql.jdbc.base.AbstractFoundryJdbcConnection;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import java.lang.reflect.Proxy;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;

public final class FoundryJdbcConnection
extends AbstractFoundryJdbcConnection {
    private static final Logger log = DriverLoggerFactory.getLogger(FoundryJdbcConnection.class);
    private final TokenSupplier tokenSupplier;
    private final ConnectionDetails session;
    private final QueryManager queryManager;
    private final SqlDialect sqlDialect;
    private final DatabaseMetaData databaseMetadata;
    private boolean closed = false;
    private boolean autoCommit = true;

    public FoundryJdbcConnection(TokenSupplier tokenSupplier, ConnectionDetails connection, QueryManager queryManager, CatalogManager catalogManager, SqlDialect sqlDialect) {
        this.tokenSupplier = tokenSupplier;
        this.session = connection;
        this.queryManager = queryManager;
        this.sqlDialect = sqlDialect;
        FoundryJdbcDatabaseMetadata metadata = new FoundryJdbcDatabaseMetadata(this, connection, catalogManager);
        this.databaseMetadata = (DatabaseMetaData)Proxy.newProxyInstance(FoundryJdbcConnection.class.getClassLoader(), new Class[]{DatabaseMetaData.class}, (_proxy, method, methodArgs) -> {
            log.info("Calling database metadata method: {} Args: {}", (Object)SafeArg.of("methodName", method.getName()), (Object)UnsafeArg.of("args", Arrays.deepToString(methodArgs)));
            return method.invoke((Object)metadata, methodArgs);
        });
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertNotClosed();
        log.info("Creating statement for connection: {}", (Object)Args.connectionId(this.session.id()));
        return new FoundryJdbcStatement(this.tokenSupplier, this, this.queryManager, this.sqlDialect);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertNotClosed();
        this.checkResultSetTypeSupported(resultSetType);
        this.checkResultSetConcurrencySupported(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertNotClosed();
        return new FoundryJdbcPreparedStatement(this.tokenSupplier, this, sql, this.sqlDialect, this.queryManager);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSetTypeSupported(resultSetType);
        this.checkResultSetConcurrencySupported(resultSetType, resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        this.checkResultSetTypeSupported(resultSetType);
        this.checkResultSetConcurrencySupported(resultSetType, resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _autoGeneratedKeys) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertNotClosed();
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertNotClosed();
        return this.autoCommit;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.assertNotClosed();
        return sql;
    }

    @Override
    public void close() {
        log.info("Closing connection {}", (Object)Args.connectionId(this.session.id()));
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        return this.databaseMetadata;
    }

    @Override
    public boolean isValid(int _timeout) {
        return !this.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertNotClosed();
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertNotClosed();
        if (!readOnly) {
            log.warn("Client set read-only mode to false");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertNotClosed();
        return 8;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertNotClosed();
    }

    @Override
    public void setCatalog(String _catalog) throws SQLException {
        this.assertNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertNotClosed();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    private void assertNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
    }

    private void checkResultSetTypeSupported(int resultSetType) throws SQLException {
        if (!this.databaseMetadata.supportsResultSetType(resultSetType)) {
            throw new SQLFeatureNotSupportedException("Connection does not support given result type: " + resultSetType);
        }
    }

    private void checkResultSetConcurrencySupported(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.databaseMetadata.supportsResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            throw new SQLFeatureNotSupportedException("Connection does not support given result set type " + resultSetType + " and concurrency: " + resultSetConcurrency);
        }
    }
}

