/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.CatalogUtils;
import com.palantir.foundry.sql.driver.catalog.PatternValue;
import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.driver.results.GenericDriverRow;
import com.palantir.foundry.sql.jdbc.base.AbstractFoundryJdbcDatabaseMetadata;
import com.palantir.foundry.sql.jdbc.results.FoundryJdbcResultSet;
import com.palantir.foundry.sql.jdbc.utils.JdbcTypeUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableType;
import shadow.palantir.driver.javax.annotation.Nullable;

final class FoundryJdbcDatabaseMetadata
extends AbstractFoundryJdbcDatabaseMetadata {
    private static final Logger log = DriverLoggerFactory.getLogger(FoundryJdbcDatabaseMetadata.class);
    private static final ImmutableList<String> TABLE_TYPES = ImmutableList.of(TableType.TABLE.toString());
    private static final String ALL_REGEX = ".*";
    private static final ImmutableList<FoundryFieldSchema> TABLE_TYPES_COLUMNS = ImmutableList.of(FoundryJdbcDatabaseMetadata.stringCol("TABLE_TYPE"));
    private static final ImmutableList<FoundryFieldSchema> CATALOGS_COLUMNS = ImmutableList.of(FoundryJdbcDatabaseMetadata.stringCol("TABLE_CAT"));
    private static final ImmutableList<FoundryFieldSchema> SCHEMAS_COLUMNS = ImmutableList.of(FoundryJdbcDatabaseMetadata.stringCol("TABLE_SCHEM"), FoundryJdbcDatabaseMetadata.stringCol("TABLE_CATALOG"));
    private static final ImmutableList<FoundryFieldSchema> TABLES_COLUMNS = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(FoundryJdbcDatabaseMetadata.stringCol("TABLE_CAT"))).add(FoundryJdbcDatabaseMetadata.stringCol("TABLE_SCHEM"))).add(FoundryJdbcDatabaseMetadata.stringCol("TABLE_NAME"))).add(FoundryJdbcDatabaseMetadata.stringCol("TABLE_TYPE"))).add(FoundryJdbcDatabaseMetadata.stringCol("REMARKS"))).add(FoundryJdbcDatabaseMetadata.stringCol("TYPE_CAT"))).add(FoundryJdbcDatabaseMetadata.stringCol("TYPE_SCHEM"))).add(FoundryJdbcDatabaseMetadata.stringCol("TYPE_NAME"))).add(FoundryJdbcDatabaseMetadata.stringCol("SELF_REFERENCING_COL_NAME"))).add(FoundryJdbcDatabaseMetadata.stringCol("REF_GENERATION"))).build();
    private final Connection connection;
    private final ConnectionDetails connectionDetails;
    private final CatalogManager catalogManager;

    FoundryJdbcDatabaseMetadata(Connection connection, ConnectionDetails connectionDetails, CatalogManager catalogManager) {
        this.connection = connection;
        this.connectionDetails = connectionDetails;
        this.catalogManager = catalogManager;
    }

    @Override
    public String getURL() {
        return "";
    }

    @Override
    public ResultSet getTableTypes() {
        return FoundryJdbcResultSet.of(TABLE_TYPES_COLUMNS, TABLE_TYPES.stream().map(xva$0 -> GenericDriverRow.of(xva$0)).collect(Collectors.toUnmodifiableList()));
    }

    @Override
    public ResultSet getCatalogs() {
        List<DriverRow> catalogs = this.catalogManager.getCatalogs(PatternValue.empty()).stream().map(CatalogInfo::getCatalogName).sorted().map(xva$0 -> GenericDriverRow.of(xva$0)).collect(Collectors.toList());
        return FoundryJdbcResultSet.of(CATALOGS_COLUMNS, catalogs);
    }

    @Override
    public ResultSet getSchemas() {
        List<DriverRow> schemas = this.catalogManager.getSchemas(PatternValue.empty(), PatternValue.empty()).stream().sorted(Comparator.comparing(SchemaInfo::getCatalogName).thenComparing(SchemaInfo::getSchemaName)).map(schema -> GenericDriverRow.of(schema.getSchemaName(), Strings.emptyToNull(schema.getCatalogName()))).collect(Collectors.toList());
        return FoundryJdbcResultSet.of(SCHEMAS_COLUMNS, schemas);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) {
        List<DriverRow> schemas = this.catalogManager.getSchemas(PatternValue.literal(catalog), PatternValue.pattern(schemaPattern, "\\")).stream().sorted(Comparator.comparing(SchemaInfo::getCatalogName).thenComparing(SchemaInfo::getSchemaName)).map(schema -> GenericDriverRow.of(schema.getSchemaName(), Strings.emptyToNull(schema.getCatalogName()))).collect(Collectors.toList());
        return FoundryJdbcResultSet.of(SCHEMAS_COLUMNS, schemas);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] _types) {
        PatternValue catalogPv = PatternValue.literal(catalog);
        PatternValue schemaPv = PatternValue.pattern(schemaPattern, "\\");
        PatternValue tablePv = PatternValue.pattern(tableNamePattern, "\\");
        List<DriverRow> tables = this.catalogManager.getTables(catalogPv, schemaPv, tablePv).stream().sorted(Comparator.comparing(TableInfo::getCatalogName).thenComparing(TableInfo::getSchemaName).thenComparing(TableInfo::getTableName)).map(table -> GenericDriverRow.of(Strings.emptyToNull(table.getCatalogName()), Strings.emptyToNull(table.getSchemaName()), table.getTableName(), table.getTableType().toString(), null, null, null, null, null, null)).collect(Collectors.toList());
        return FoundryJdbcResultSet.of(TABLES_COLUMNS, tables);
    }

    @Override
    public ResultSet getColumns(@Nullable String catalog, @Nullable String schemaPattern, String tableNamePattern, @Nullable String columnNamePattern) throws SQLException {
        log.info("Calling getColumns. Catalog: {} Schema: {} Table: {} ColumnNames: {}", UnsafeArg.of("catalog", catalog), UnsafeArg.of("schemaPattern", schemaPattern), UnsafeArg.of("tableNamePattern", tableNamePattern), UnsafeArg.of("columnNamePattern", columnNamePattern));
        PatternValue catalogPv = PatternValue.literal(catalog);
        PatternValue schemaPv = PatternValue.pattern(schemaPattern, "\\");
        PatternValue tablePv = PatternValue.pattern(tableNamePattern, "\\");
        Pattern columnRegex = Pattern.compile(Optional.ofNullable(columnNamePattern).map(pattern -> CatalogUtils.patternToRegex(pattern, "\\")).orElse(ALL_REGEX));
        List<FoundryFieldSchema> columns = this.catalogManager.getColumns(catalogPv, schemaPv, tablePv, this.connectionDetails.fallbackBranchIds()).stream().filter(col -> columnRegex.matcher(col.getName().orElseThrow(() -> new SafeRuntimeException("Missing column name", new Arg[0]))).matches()).collect(Collectors.toList());
        if (this.connectionDetails.reversedCatalogSchema() || this.connectionDetails.schemasOnlyCatalog()) {
            return JdbcTypeUtils.foundryFieldsToColumnMetadata(Optional.empty(), schemaPv.asApi(), tablePv.asApi().orElse(""), columns);
        }
        return JdbcTypeUtils.foundryFieldsToColumnMetadata(catalogPv.asApi(), Optional.empty(), tablePv.asApi().orElse(""), columns);
    }

    @Override
    public ResultSet getPrimaryKeys(String _catalog, String _schema, String _table) {
        return FoundryJdbcResultSet.emptyResultSet();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return FoundryJdbcResultSet.emptyResultSet();
    }

    @Override
    public ResultSet getIndexInfo(String _catalog, String _schema, String _table, boolean _unique, boolean _approximate) {
        return FoundryJdbcResultSet.emptyResultSet();
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return this.supportsResultSetType(type) && concurrency == 1007;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    private static FoundryFieldSchema stringCol(String name) {
        return FoundryFieldSchema.builder().type(FoundryFieldType.STRING).name(name).nullable(true).build();
    }
}

