/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.auth.TokenSupplier;
import com.palantir.foundry.sql.driver.auth.TokenSupplierVisitor;
import com.palantir.foundry.sql.driver.catalog.CatalogManager;
import com.palantir.foundry.sql.driver.catalog.CatalogManagerFactory;
import com.palantir.foundry.sql.driver.clients.ServiceClients;
import com.palantir.foundry.sql.driver.clients.ServiceClientsFactory;
import com.palantir.foundry.sql.driver.clients.ServiceClientsLoader;
import com.palantir.foundry.sql.driver.connection.ConnectionDetails;
import com.palantir.foundry.sql.driver.logging.Args;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.schema.TimezoneConverter;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.driver.statement.QueryManagerFactory;
import com.palantir.foundry.sql.jdbc.FoundryJdbcConnection;
import com.palantir.foundry.sql.jdbc.JdbcConnectionStringConfig;
import com.palantir.foundry.sql.jdbc.JdbcConnectionStringParser;
import com.palantir.foundry.sql.jdbc.config.JdbcIniFileReader;
import com.palantir.foundry.sql.jdbc.utils.FoundryJdbcConstants;
import com.palantir.foundry.sql.jdbc.utils.TempDirectoryUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlMetadataServiceBlocking;

public final class FoundryJdbcDriver
implements Driver {
    private static final Logger log = DriverLoggerFactory.getLogger(FoundryJdbcDriver.class);
    private static final String JAVA_TEMP_DIRECTORY_PROPERTY = "java.io.tmpdir";
    private static final String DEFAULT_TEMP_SUB_DIRECTORY = "foundry-jdbc";
    private final JdbcConnectionStringParser jdbcConnectionStringParser = new JdbcConnectionStringParser(JdbcIniFileReader.INSTANCE);
    private final UUID driverId = UUID.randomUUID();

    public FoundryJdbcDriver() {
        log.info("Creating new driver instance {}. Classloader: {} JVM: {}", SafeArg.of("driverId", this.driverId), UnsafeArg.of("classLoader", FoundryJdbcDriver.class.getClassLoader()), UnsafeArg.of("jvm", ManagementFactory.getRuntimeMXBean().getName()));
    }

    @Override
    public Connection connect(String jdbcUrl, Properties defaults) throws SQLException {
        log.info("Creating new connection for driver: {}", (Object)SafeArg.of("driverId", this.driverId));
        Optional<JdbcConnectionStringConfig> maybeConnectionProperties = this.jdbcConnectionStringParser.tryParseJdbcUri(jdbcUrl, defaults);
        if (!maybeConnectionProperties.isPresent()) {
            log.warn("Couldn't parse JDBC URI");
            return null;
        }
        JdbcConnectionStringConfig properties = maybeConnectionProperties.get();
        if (properties.logDirectory().isPresent()) {
            DriverLoggerFactory.initFileLogging(properties.logDirectory().get());
        } else {
            DriverLoggerFactory.disableFileLogging();
        }
        Optional<Path> maybeTempDirectory = FoundryJdbcDriver.getTemporaryDirectory(properties.nativeLibTempDirectory());
        if (maybeTempDirectory.isPresent()) {
            Path tempDirectory = maybeTempDirectory.get();
            TempDirectoryUtils.cleanupTempLibFiles(tempDirectory);
            log.info("Native lib temp directory: {}", (Object)UnsafeArg.of("tempDirectory", tempDirectory));
            System.setProperty("jna.tmpdir", tempDirectory.toString());
            System.setProperty("ZstdTempFolder", tempDirectory.toString());
        }
        ServiceClients serviceClients = ServiceClientsLoader.getInstance().get(properties.common().networkClientConfig(), ServiceClientsFactory.INSTANCE);
        TokenSupplier tokenSupplier = properties.common().authMethod().accept(new TokenSupplierVisitor(serviceClients, "Foundry_JDBC_Driver_OAuth"));
        ConnectionDetails connection = ConnectionDetails.create(properties.common());
        log.info("Created connection: {}", (Object)Args.connectionId(connection.id()));
        QueryManager queryManager = QueryManagerFactory.get(tokenSupplier, serviceClients, connection, properties.common(), TimezoneConverter.utc(), ZoneOffset.UTC);
        SqlMetadataServiceBlocking sqlMetadataService = serviceClients.sqlMetadataServiceBlocking();
        CatalogManager catalogManager = CatalogManagerFactory.get(properties.common(), tokenSupplier, sqlMetadataService);
        return new FoundryJdbcConnection(tokenSupplier, connection, queryManager, catalogManager, properties.common().sqlDialect());
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        log.info("Checking URL");
        if (url == null) {
            throw new SQLException("Url is null");
        }
        return JdbcConnectionStringParser.acceptsJdbcUri(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String _url, Properties _info) {
        log.warn("Calling getPropertyInfo");
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return FoundryJdbcConstants.majorVersion();
    }

    @Override
    public int getMinorVersion() {
        return FoundryJdbcConstants.minorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Currently not supported in Foundry JDBC driver");
    }

    private static Optional<Path> getTemporaryDirectory(Optional<Path> nativeLibTempDirectory) {
        if (nativeLibTempDirectory.isPresent()) {
            return Optional.of(nativeLibTempDirectory.get());
        }
        Path javaTempDir = Paths.get(System.getProperty(JAVA_TEMP_DIRECTORY_PROPERTY), new String[0]);
        Path tempDir = javaTempDir.resolve(DEFAULT_TEMP_SUB_DIRECTORY);
        try {
            Files.createDirectories(tempDir, new FileAttribute[0]);
            return Optional.of(tempDir);
        }
        catch (Exception e) {
            log.debug("Failed creating temp dir", e);
            return Optional.empty();
        }
    }

    static {
        try {
            DriverManager.registerDriver(new FoundryJdbcDriver());
        }
        catch (SQLException e) {
            throw new SafeRuntimeException("Failed to register Foundry driver", new Arg[0]);
        }
    }
}

