/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.statement.ParameterizedQuery;
import com.palantir.foundry.sql.driver.statement.QueryManager;
import com.palantir.foundry.sql.jdbc.FoundryJdbcBaseStatement;
import com.palantir.foundry.sql.jdbc.base.AbstractFoundryJdbcPreparedStatement;
import com.palantir.foundry.sql.jdbc.utils.EmptyParameterMetadata;
import com.palantir.logsafe.SafeArg;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ParameterValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

final class FoundryJdbcPreparedStatement
extends FoundryJdbcBaseStatement
implements AbstractFoundryJdbcPreparedStatement {
    private static final Logger log = DriverLoggerFactory.getLogger(FoundryJdbcPreparedStatement.class);
    private final ParameterizedQuery parameterizedQuery;
    private final SqlDialect sqlDialect;
    private final List<ParameterValue> parameters;
    private Optional<ResultSetMetaData> currentResultSetMetadata = Optional.empty();

    FoundryJdbcPreparedStatement(Supplier<AuthHeader> authHeader, Connection connection, String sqlQuery, SqlDialect sqlDialect, QueryManager queryManager) throws SQLException {
        super(authHeader, connection, queryManager);
        this.parameterizedQuery = ParameterizedQuery.of(sqlQuery);
        this.parameters = new ArrayList<Object>(Collections.nCopies(this.parameterizedQuery.numUniqueParams(), null));
        this.sqlDialect = sqlDialect;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Parameters params = this.getParameters();
        return this.executeSql(this.parameterizedQuery.sql(), this.sqlDialect, params);
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeQuery();
        return true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        if (this.getResultSet() != null) {
            return this.getResultSet().getMetaData();
        }
        if (this.currentResultSetMetadata.isPresent()) {
            log.debug("Using cached result set metadata");
            return this.currentResultSetMetadata.get();
        }
        try {
            Optional<Parameters> maybeParams = this.maybeGetParameters();
            if (maybeParams.isEmpty()) {
                log.warn("Loading metadata without all parameters set is not supported");
                return null;
            }
            this.currentResultSetMetadata = Optional.of(this.describeSql(this.parameterizedQuery.sql(), this.sqlDialect, maybeParams.get()));
            return this.currentResultSetMetadata.get();
        }
        catch (Exception e) {
            log.warn("Error describing query, will return null", e);
            return null;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return new EmptyParameterMetadata(this.parameterizedQuery.numUniqueParams());
    }

    private Optional<Parameters> maybeGetParameters() {
        int expectedParameterCount;
        long numParametersSet = this.parameters.stream().filter(Objects::nonNull).count();
        if (numParametersSet != (long)(expectedParameterCount = this.parameterizedQuery.numUniqueParams())) {
            log.warn("One or more query parameters have not been set. Expected {}, got {}", (Object)SafeArg.of("expectedParameterCount", expectedParameterCount), (Object)SafeArg.of("actualParameterCount", numParametersSet));
            return Optional.empty();
        }
        return Optional.of(Parameters.unnamedParameterValues(this.parameters));
    }

    private Parameters getParameters() throws SQLException {
        int expectedParameterCount;
        long numParametersSet = this.parameters.stream().filter(Objects::nonNull).count();
        if (numParametersSet != (long)(expectedParameterCount = this.parameterizedQuery.numUniqueParams())) {
            throw new SQLException(String.format(Locale.ROOT, "One or more query parameters have not been set. Expected %d, got %d", expectedParameterCount, numParametersSet));
        }
        return Parameters.unnamedParameterValues(this.parameters);
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.assertNotClosed();
        this.checkParameterIndexInBounds(parameterIndex);
        if (value == null) {
            this.setNull(parameterIndex, 1111);
        } else if (value instanceof String) {
            this.setString(parameterIndex, (String)value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)value);
        } else if (value instanceof Short) {
            this.setShort(parameterIndex, (Short)value);
        } else if (value instanceof Integer) {
            this.setInt(parameterIndex, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(parameterIndex, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(parameterIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(parameterIndex, (Double)value);
        } else if (value instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])value);
        } else if (value instanceof Date) {
            this.setDate(parameterIndex, (Date)value);
        } else if (value instanceof Time) {
            this.setTime(parameterIndex, (Time)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)value);
        } else if (value instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(parameterIndex, (Byte)value);
        } else if (value instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)value);
        } else if (value instanceof Clob) {
            this.setClob(parameterIndex, (Clob)value);
        } else if (value instanceof Array) {
            this.setArray(parameterIndex, (Array)value);
        } else {
            throw new SQLException(String.format("Unsupported parameter type: %s", value.getClass().getName()));
        }
    }

    @Override
    public void setObject(int _parameterIndex, Object _value, int _targetSqlType) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Currently unimplemented.");
    }

    @Override
    public void setObject(int _parameterIndex, Object _value, int _targetSqlType, int _scaleOrLength) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Currently unimplemented.");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.decimal(value));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.boolean_(value));
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.short_(value));
    }

    @Override
    public void setBytes(int _parameterIndex, byte[] _bytes) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Byte array parameters are currently unimplemented");
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.date(value));
    }

    @Override
    public void setDate(int _parameterIndex, Date _value, Calendar _cal) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.double_(value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.float_(value));
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.integer(value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.long_(SafeLong.of(value)));
    }

    @Override
    public void setNull(int _parameterIndex, int _sqlType) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Null parameters are currently unimplemented");
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.short_(value));
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.string(value));
    }

    @Override
    public void setTime(int _parameterIndex, Time _value) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Time parameters are not currently implemented");
    }

    @Override
    public void setTime(int _parameterIndex, Time _value, Calendar _cal) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Time parameters are not currently implemented");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.assertNotClosed();
        this.setParameter(parameterIndex, ParameterValue.timestamp(value));
    }

    @Override
    public void setTimestamp(int _parameterIndex, Timestamp _value, Calendar _cal) throws SQLException {
        this.assertNotClosed();
        throw new SQLFeatureNotSupportedException("Setting Timestamp parameter with Calendar is not currently implemented");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.assertNotClosed();
        this.parameters.clear();
        this.currentResultSetMetadata = Optional.empty();
    }

    private void setParameter(int parameterIndex, ParameterValue param) throws SQLException {
        this.assertNotClosed();
        this.checkParameterIndexInBounds(parameterIndex);
        this.parameters.set(parameterIndex - 1, param);
        this.currentResultSetMetadata = Optional.empty();
    }

    private void checkParameterIndexInBounds(int index) throws SQLException {
        int parameterCount = this.parameterizedQuery.numUniqueParams();
        if (index < 1 || index > parameterCount) {
            throw new SQLException(String.format(Locale.ROOT, "Parameter index (%d) is out of bounds of parameter count (%d)", index, parameterCount));
        }
    }
}

