/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.jdbc.JdbcConnectionStringParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JdbcConnectionStringParser.FoundryJdbcUri", generator="Immutables")
@Immutable
final class ImmutableFoundryJdbcUri
implements JdbcConnectionStringParser.FoundryJdbcUri {
    private final URI hostPort;
    private final ImmutableMap<String, String> parameters;

    private ImmutableFoundryJdbcUri(URI hostPort, Map<String, ? extends String> parameters) {
        this.hostPort = Objects.requireNonNull(hostPort, "hostPort");
        this.parameters = ImmutableMap.copyOf(parameters);
    }

    private ImmutableFoundryJdbcUri(ImmutableFoundryJdbcUri original, URI hostPort, ImmutableMap<String, String> parameters) {
        this.hostPort = hostPort;
        this.parameters = parameters;
    }

    @Override
    public URI hostPort() {
        return this.hostPort;
    }

    public ImmutableMap<String, String> parameters() {
        return this.parameters;
    }

    public final ImmutableFoundryJdbcUri withHostPort(URI value) {
        if (this.hostPort == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "hostPort");
        return new ImmutableFoundryJdbcUri(this, newValue, this.parameters);
    }

    public final ImmutableFoundryJdbcUri withParameters(Map<String, ? extends String> entries) {
        if (this.parameters == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFoundryJdbcUri(this, this.hostPort, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFoundryJdbcUri && this.equalsByValue((ImmutableFoundryJdbcUri)another);
    }

    private boolean equalsByValue(ImmutableFoundryJdbcUri another) {
        return this.hostPort.equals(another.hostPort) && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hostPort.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FoundryJdbcUri").omitNullValues().add("hostPort", this.hostPort).add("parameters", this.parameters).toString();
    }

    public static ImmutableFoundryJdbcUri of(URI hostPort, Map<String, ? extends String> parameters) {
        return new ImmutableFoundryJdbcUri(hostPort, parameters);
    }

    public static ImmutableFoundryJdbcUri copyOf(JdbcConnectionStringParser.FoundryJdbcUri instance) {
        if (instance instanceof ImmutableFoundryJdbcUri) {
            return (ImmutableFoundryJdbcUri)instance;
        }
        return ImmutableFoundryJdbcUri.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JdbcConnectionStringParser.FoundryJdbcUri", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST_PORT = 1L;
        private long initBits = 1L;
        @Nullable
        private URI hostPort;
        private ImmutableMap.Builder<String, String> parameters = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JdbcConnectionStringParser.FoundryJdbcUri instance) {
            Objects.requireNonNull(instance, "instance");
            this.hostPort(instance.hostPort());
            this.putAllParameters(instance.parameters());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hostPort(URI hostPort) {
            this.hostPort = Objects.requireNonNull(hostPort, "hostPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameters(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameters(Map.Entry<String, ? extends String> entry) {
            this.parameters.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameters(Map<String, ? extends String> entries) {
            this.parameters = ImmutableMap.builder();
            return this.putAllParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllParameters(Map<String, ? extends String> entries) {
            this.parameters.putAll(entries);
            return this;
        }

        public ImmutableFoundryJdbcUri build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFoundryJdbcUri(null, this.hostPort, this.parameters.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hostPort");
            }
            return "Cannot build FoundryJdbcUri, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

