/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.config.CommonDriverConfig;
import com.palantir.foundry.sql.jdbc.JdbcConnectionStringConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JdbcConnectionStringConfig", generator="Immutables")
@Immutable
final class ImmutableJdbcConnectionStringConfig
implements JdbcConnectionStringConfig {
    private final CommonDriverConfig common;
    @Nullable
    private final Path logDirectory;
    @Nullable
    private final Path nativeLibTempDirectory;

    private ImmutableJdbcConnectionStringConfig(CommonDriverConfig common, @Nullable Path logDirectory, @Nullable Path nativeLibTempDirectory) {
        this.common = common;
        this.logDirectory = logDirectory;
        this.nativeLibTempDirectory = nativeLibTempDirectory;
    }

    @Override
    public CommonDriverConfig common() {
        return this.common;
    }

    @Override
    public Optional<Path> logDirectory() {
        return Optional.ofNullable(this.logDirectory);
    }

    @Override
    public Optional<Path> nativeLibTempDirectory() {
        return Optional.ofNullable(this.nativeLibTempDirectory);
    }

    public final ImmutableJdbcConnectionStringConfig withCommon(CommonDriverConfig value) {
        if (this.common == value) {
            return this;
        }
        CommonDriverConfig newValue = Objects.requireNonNull(value, "common");
        return new ImmutableJdbcConnectionStringConfig(newValue, this.logDirectory, this.nativeLibTempDirectory);
    }

    public final ImmutableJdbcConnectionStringConfig withLogDirectory(Path value) {
        Path newValue = Objects.requireNonNull(value, "logDirectory");
        if (this.logDirectory == newValue) {
            return this;
        }
        return new ImmutableJdbcConnectionStringConfig(this.common, newValue, this.nativeLibTempDirectory);
    }

    public final ImmutableJdbcConnectionStringConfig withLogDirectory(Optional<? extends Path> optional) {
        Path value = optional.orElse(null);
        if (this.logDirectory == value) {
            return this;
        }
        return new ImmutableJdbcConnectionStringConfig(this.common, value, this.nativeLibTempDirectory);
    }

    public final ImmutableJdbcConnectionStringConfig withNativeLibTempDirectory(Path value) {
        Path newValue = Objects.requireNonNull(value, "nativeLibTempDirectory");
        if (this.nativeLibTempDirectory == newValue) {
            return this;
        }
        return new ImmutableJdbcConnectionStringConfig(this.common, this.logDirectory, newValue);
    }

    public final ImmutableJdbcConnectionStringConfig withNativeLibTempDirectory(Optional<? extends Path> optional) {
        Path value = optional.orElse(null);
        if (this.nativeLibTempDirectory == value) {
            return this;
        }
        return new ImmutableJdbcConnectionStringConfig(this.common, this.logDirectory, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdbcConnectionStringConfig && this.equalsByValue((ImmutableJdbcConnectionStringConfig)another);
    }

    private boolean equalsByValue(ImmutableJdbcConnectionStringConfig another) {
        return this.common.equals(another.common) && Objects.equals(this.logDirectory, another.logDirectory) && Objects.equals(this.nativeLibTempDirectory, another.nativeLibTempDirectory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.common.hashCode();
        h += (h << 5) + Objects.hashCode(this.logDirectory);
        h += (h << 5) + Objects.hashCode(this.nativeLibTempDirectory);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("JdbcConnectionStringConfig").omitNullValues().add("common", this.common).add("logDirectory", this.logDirectory).add("nativeLibTempDirectory", this.nativeLibTempDirectory).toString();
    }

    public static ImmutableJdbcConnectionStringConfig copyOf(JdbcConnectionStringConfig instance) {
        if (instance instanceof ImmutableJdbcConnectionStringConfig) {
            return (ImmutableJdbcConnectionStringConfig)instance;
        }
        return new JdbcConnectionStringConfig.Builder().from(instance).build();
    }

    @Generated(from="JdbcConnectionStringConfig", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_COMMON = 1L;
        private long initBits = 1L;
        @Nullable
        private CommonDriverConfig common;
        @Nullable
        private Path logDirectory;
        @Nullable
        private Path nativeLibTempDirectory;

        public Builder() {
            if (!(this instanceof JdbcConnectionStringConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new JdbcConnectionStringConfig.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final JdbcConnectionStringConfig.Builder from(JdbcConnectionStringConfig instance) {
            Optional<Path> nativeLibTempDirectoryOptional;
            Objects.requireNonNull(instance, "instance");
            this.common(instance.common());
            Optional<Path> logDirectoryOptional = instance.logDirectory();
            if (logDirectoryOptional.isPresent()) {
                this.logDirectory(logDirectoryOptional);
            }
            if ((nativeLibTempDirectoryOptional = instance.nativeLibTempDirectory()).isPresent()) {
                this.nativeLibTempDirectory(nativeLibTempDirectoryOptional);
            }
            return (JdbcConnectionStringConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final JdbcConnectionStringConfig.Builder common(CommonDriverConfig common) {
            this.common = Objects.requireNonNull(common, "common");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (JdbcConnectionStringConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final JdbcConnectionStringConfig.Builder logDirectory(Path logDirectory) {
            this.logDirectory = Objects.requireNonNull(logDirectory, "logDirectory");
            return (JdbcConnectionStringConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final JdbcConnectionStringConfig.Builder logDirectory(Optional<? extends Path> logDirectory) {
            this.logDirectory = logDirectory.orElse(null);
            return (JdbcConnectionStringConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final JdbcConnectionStringConfig.Builder nativeLibTempDirectory(Path nativeLibTempDirectory) {
            this.nativeLibTempDirectory = Objects.requireNonNull(nativeLibTempDirectory, "nativeLibTempDirectory");
            return (JdbcConnectionStringConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final JdbcConnectionStringConfig.Builder nativeLibTempDirectory(Optional<? extends Path> nativeLibTempDirectory) {
            this.nativeLibTempDirectory = nativeLibTempDirectory.orElse(null);
            return (JdbcConnectionStringConfig.Builder)this;
        }

        public ImmutableJdbcConnectionStringConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJdbcConnectionStringConfig(this.common, this.logDirectory, this.nativeLibTempDirectory);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("common");
            }
            return "Cannot build JdbcConnectionStringConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

