/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc;

import com.palantir.foundry.sql.driver.config.CommonDriverConfig;
import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.jdbc.ImmutableFoundryJdbcUri;
import com.palantir.foundry.sql.jdbc.JdbcConnectionStringConfig;
import com.palantir.foundry.sql.jdbc.config.JdbcIniFile;
import com.palantir.foundry.sql.jdbc.config.JdbcIniFileReader;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Splitter;
import shadow.palantir.driver.org.immutables.value.Value;

final class JdbcConnectionStringParser {
    private static final Logger log = DriverLoggerFactory.getLogger(JdbcConnectionStringParser.class);
    private static final Splitter HOST_PARAM_SPLITTER = Splitter.on('?').omitEmptyStrings();
    private static final Splitter PARAM_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter PARAM_KEY_VALUE_SPLITTER = Splitter.on('=');
    @VisibleForTesting
    static final String PROPERTIES_FILE = "foundry.ini";
    private final JdbcIniFileReader iniFileReader;

    JdbcConnectionStringParser(JdbcIniFileReader iniFileReader) {
        this.iniFileReader = iniFileReader;
    }

    Optional<JdbcConnectionStringConfig> tryParseJdbcUri(String jdbcUri, Properties defaults) throws SQLException {
        Optional<FoundryJdbcUri> maybeFoundryUri = JdbcConnectionStringParser.validateFoundryUri(jdbcUri);
        if (!maybeFoundryUri.isPresent()) {
            log.warn("Couldn't parse properties");
            return Optional.empty();
        }
        return Optional.of(this.parseFoundryJdbcUri(maybeFoundryUri.get(), defaults));
    }

    static boolean acceptsJdbcUri(String jdbcUrl) {
        return JdbcConnectionStringParser.validateFoundryUri(jdbcUrl).isPresent();
    }

    private static Optional<FoundryJdbcUri> validateFoundryUri(String jdbcUrl) {
        URI uri;
        String withoutJdbcUrl = jdbcUrl.replaceFirst("^jdbc:", "");
        String withoutHttpsUrl = withoutJdbcUrl.replaceFirst(String.format("^%s:(//)?https:(//)?", "foundrysql"), String.format("%s://", "foundrysql"));
        List<String> hostAndParams = HOST_PARAM_SPLITTER.splitToList(withoutHttpsUrl);
        if (hostAndParams.size() > 2) {
            log.warn("Invalid URI, too many `?` characters");
            return Optional.empty();
        }
        try {
            uri = new URI(hostAndParams.get(0));
        }
        catch (URISyntaxException e) {
            log.warn("Invalid URI syntax");
            return Optional.empty();
        }
        if (!uri.getScheme().equals("foundrysql")) {
            return Optional.empty();
        }
        String params = hostAndParams.stream().skip(1L).findFirst().orElse("");
        Map<String, String> connectionParameters = PARAM_SPLITTER.splitToList(params).stream().map(PARAM_KEY_VALUE_SPLITTER::splitToList).peek(keyValue -> Preconditions.checkArgument(keyValue.size() == 2, "Invalid connection parameters syntax")).collect(Collectors.toMap(keyValue -> (String)keyValue.get(0), keyValue -> (String)keyValue.get(1)));
        return Optional.of(ImmutableFoundryJdbcUri.of(uri, connectionParameters));
    }

    private JdbcConnectionStringConfig parseFoundryJdbcUri(FoundryJdbcUri foundryUri, Properties defaults) throws SQLException {
        String host = Optional.ofNullable(foundryUri.hostPort().getHost()).orElseThrow(() -> new SQLException(foundryUri.toString(), "Foundry URL is not set"));
        int port = foundryUri.hostPort().getPort();
        String foundryUrl = String.format("https://%s%s/", host, port > 0 ? ":" + port : "");
        Map<String, String> defaultParams = defaults.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
        JdbcIniFile iniConfig = this.iniFileReader.readConfigFile(PROPERTIES_FILE);
        TreeMap<String, String> params = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        params.putAll(iniConfig.lowPriority());
        params.putAll(defaultParams);
        params.putAll(foundryUri.parameters());
        params.putAll(iniConfig.highPriority());
        Optional<Path> logPath = JdbcConnectionStringParser.folderPath(params, "LogPath", false);
        Optional<Path> nativeLibTempDirectory = JdbcConnectionStringParser.folderPath(params, "NativeLibTempDir", true);
        return JdbcConnectionStringConfig.builder().common(CommonDriverConfig.of(params, foundryUrl, "foundry-sql-jdbc-driver", "user", "password")).logDirectory(logPath).nativeLibTempDirectory(nativeLibTempDirectory).build();
    }

    private static Optional<Path> folderPath(Map<String, String> params, String property, boolean requiresExecutable) {
        Optional<Path> maybePath = Optional.ofNullable(params.get(property)).map(x$0 -> Paths.get(x$0, new String[0]));
        maybePath.ifPresent(path -> Preconditions.checkArgument(Files.isDirectory(path, new LinkOption[0]), "Path does not exist or is not a directory", SafeArg.of("property", property), UnsafeArg.of("path", path)));
        maybePath.ifPresent(path -> Preconditions.checkArgument(Files.isWritable(path), "Directory is not writable", SafeArg.of("property", property), UnsafeArg.of("path", path)));
        maybePath.ifPresent(path -> {
            if (requiresExecutable && !Files.isExecutable(path)) {
                log.warn("Property {} with directory {} is not executable", (Object)UnsafeArg.of("property", property), (Object)UnsafeArg.of("path", path));
            }
        });
        return maybePath;
    }

    @Value.Immutable
    static interface FoundryJdbcUri {
        @Value.Parameter
        public URI hostPort();

        @Value.Parameter
        public Map<String, String> parameters();
    }
}

