/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.config;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.jdbc.config.ImmutableJdbcIniFile;
import com.palantir.foundry.sql.jdbc.config.JdbcIniFile;
import com.palantir.foundry.sql.os.utils.FileUtils;
import com.palantir.logsafe.UnsafeArg;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.Streams;
import shadow.palantir.driver.org.apache.commons.configuration2.Configuration;
import shadow.palantir.driver.org.apache.commons.configuration2.INIConfiguration;

public enum JdbcIniFileReader {
    INSTANCE;

    private static final Logger log;
    private static final String HIGH_PRIORITY_SECTION = "high-priority";
    private static final String LOW_PRIORITY_SECTION = "low-priority";

    public JdbcIniFile readConfigFile(String fileName) {
        Path configFilePath = FileUtils.getJarFolder(JdbcIniFileReader.class).resolve(fileName);
        return this.readConfigFile(configFilePath);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    JdbcIniFile readConfigFile(Path configFilePath) {
        if (!JdbcIniFileReader.exists(configFilePath)) {
            log.info("Properties file not found: {}", (Object)UnsafeArg.of("filePath", configFilePath));
            return JdbcIniFile.empty();
        }
        INIConfiguration config = new INIConfiguration();
        try (InputStream is = Files.newInputStream(configFilePath, StandardOpenOption.READ);){
            ImmutableJdbcIniFile immutableJdbcIniFile;
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                config.read(reader);
                log.info("Found properties file: {}", (Object)UnsafeArg.of("filePath", configFilePath));
                Map lowPriorityProperties = Optional.ofNullable(config.getSection(LOW_PRIORITY_SECTION)).map(JdbcIniFileReader::convertSectionToMap).orElseGet(Collections::emptyMap);
                Map highPriorityProperties = Optional.ofNullable(config.getSection(HIGH_PRIORITY_SECTION)).map(JdbcIniFileReader::convertSectionToMap).orElseGet(Collections::emptyMap);
                immutableJdbcIniFile = JdbcIniFile.builder().lowPriority(lowPriorityProperties).highPriority(highPriorityProperties).build();
            }
            return immutableJdbcIniFile;
        }
        catch (Exception e) {
            log.warn("Error opening properties file: {}", (Object)UnsafeArg.of("filePath", configFilePath), (Object)e);
            return JdbcIniFile.empty();
        }
    }

    private static boolean exists(Path configFilePath) {
        try {
            return !Files.notExists(configFilePath, new LinkOption[0]);
        }
        catch (Exception e) {
            log.debug("Error checking for properties file: {}", (Object)UnsafeArg.of("filePath", configFilePath), (Object)e);
            return false;
        }
    }

    private static Map<String, String> convertSectionToMap(Configuration section) {
        return Streams.stream(section.getKeys()).collect(Collectors.toMap(key -> key, key -> section.getString((String)key, "")));
    }

    static {
        log = DriverLoggerFactory.getLogger(JdbcIniFileReader.class);
    }
}

