/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.results;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.driver.results.AutoCloseableIterator;
import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.jdbc.base.AbstractFoundryJdbcResultSet;
import com.palantir.foundry.sql.jdbc.results.FoundryJdbcResultSetMetaData;
import com.palantir.foundry.sql.jdbc.results.JdbcDriverRow;
import com.palantir.foundry.sql.jdbc.results.JdbcDriverRowIterator;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;

public final class FoundryJdbcResultSet
extends AbstractFoundryJdbcResultSet {
    private static final Logger log = DriverLoggerFactory.getLogger(FoundryJdbcResultSet.class);
    private final FoundryJdbcResultSetMetaData metaData;
    private final AutoCloseableIterator<JdbcDriverRow> results;
    private final Map<String, Integer> columnNameIndex;
    private final Optional<Statement> statement;
    private boolean closed = false;
    private JdbcDriverRow currentRow;

    private FoundryJdbcResultSet(Optional<Statement> statement, List<FoundryFieldSchema> columnTypes, AutoCloseableIterator<DriverRow> results) {
        this.metaData = new FoundryJdbcResultSetMetaData(columnTypes);
        this.statement = statement;
        this.currentRow = null;
        this.results = new JdbcDriverRowIterator(results, columnTypes);
        this.columnNameIndex = IntStream.range(0, columnTypes.size()).boxed().collect(Collectors.toMap(ordinal -> ((FoundryFieldSchema)columnTypes.get((int)ordinal)).getName().orElseThrow(() -> new SafeIllegalStateException("No column name", new Arg[0])), ordinal -> ordinal + 1));
    }

    public static FoundryJdbcResultSet emptyResultSet() {
        return FoundryJdbcResultSet.of(Collections.emptyList(), Collections.emptyList());
    }

    public static FoundryJdbcResultSet of(List<FoundryFieldSchema> columnTypes, List<DriverRow> results) {
        return new FoundryJdbcResultSet(Optional.empty(), columnTypes, AutoCloseableIterator.wrap(results.iterator()));
    }

    public static FoundryJdbcResultSet of(List<FoundryFieldSchema> columnTypes, AutoCloseableIterator<DriverRow> results) {
        return new FoundryJdbcResultSet(Optional.empty(), columnTypes, results);
    }

    public static FoundryJdbcResultSet of(Statement statement, List<FoundryFieldSchema> columnTypes, AutoCloseableIterator<DriverRow> results) {
        return new FoundryJdbcResultSet(Optional.of(statement), columnTypes, results);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        return this.metaData;
    }

    @Override
    public boolean next() throws SQLException {
        this.assertNotClosed();
        if (this.results.hasNext()) {
            this.currentRow = (JdbcDriverRow)this.results.next();
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Cannot iterate backward over results");
    }

    @Override
    public void close() throws SQLException {
        log.info("Closing result set");
        this.closed = true;
        if (this.statement.isPresent() && this.statement.get().isCloseOnCompletion()) {
            this.statement.get().close();
        }
        this.results.close();
    }

    @Override
    public boolean wasNull() {
        return this.currentRow.lastValueReadWasNull();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.currentRow.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int _columnIndex, Map<String, Class<?>> _map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Object getObject(String _columnLabel, Map<String, Class<?>> _map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public <T> T getObject(int _columnIndex, Class<T> _type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public <T> T getObject(String _columnLabel, Class<T> _type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.currentRow.getString(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.currentRow.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.currentRow.getByte(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.currentRow.getShort(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.currentRow.getInteger(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.currentRow.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.currentRow.getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.currentRow.getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int _columnIndex, int _scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public BigDecimal getBigDecimal(String _columnLabel, int _scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.currentRow.getDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.currentRow.getBinary(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), null);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.currentRow.getSqlDate(columnIndex, Optional.ofNullable(cal));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Time type not supported");
    }

    @Override
    public Time getTime(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Time type not supported");
    }

    @Override
    public Time getTime(int _columnIndex, Calendar _cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Time type not supported");
    }

    @Override
    public Time getTime(String _columnLabel, Calendar _cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Time type not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.currentRow.getSqlTimestamp(columnIndex, Optional.ofNullable(cal));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public InputStream getAsciiStream(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public InputStream getAsciiStream(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public InputStream getUnicodeStream(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public InputStream getUnicodeStream(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public InputStream getBinaryStream(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public InputStream getBinaryStream(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer ordinal = this.columnNameIndex.get(columnLabel);
        if (ordinal == null) {
            throw new SQLException("No columnLabel " + columnLabel + " found in FoundrySchema");
        }
        return ordinal;
    }

    @Override
    public Reader getCharacterStream(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Reader getCharacterStream(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isLast() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public void afterLast() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean first() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public int getRow() throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean absolute(int _row) throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean relative(int _rows) throws SQLException {
        this.assertNotClosed();
        throw new SQLException("Foundry resultsets are TYPE_FORWARD_ONLY");
    }

    @Override
    public void setFetchDirection(int _direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cannot set fetch direction");
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int _rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public void moveToCurrentRow() {
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.assertNotClosed();
        return this.statement.orElse(null);
    }

    @Override
    public Ref getRef(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Ref getRef(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Blob getBlob(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Blob getBlob(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Clob getClob(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Clob getClob(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Array getArray(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Array getArray(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public URL getURL(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public URL getURL(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public RowId getRowId(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public RowId getRowId(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public NClob getNClob(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public NClob getNClob(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public SQLXML getSQLXML(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public SQLXML getSQLXML(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public String getNString(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public String getNString(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Reader getNCharacterStream(int _columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public Reader getNCharacterStream(String _columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Currently unimplemented");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    private void assertNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed");
        }
    }
}

