/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.results;

import com.palantir.foundry.sql.jdbc.utils.JdbcTypeUtils;
import com.palantir.logsafe.Unsafe;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;

public final class FoundryJdbcResultSetMetaData
implements ResultSetMetaData {
    private final List<FoundryFieldSchema> columnTypes;

    public FoundryJdbcResultSetMetaData(List<FoundryFieldSchema> columnTypes) {
        this.columnTypes = columnTypes;
    }

    @Override
    public int getColumnCount() {
        return this.columnTypes.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnRange(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumnRange(column);
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumnRange(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumnRange(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkColumnRange(column);
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkColumnRange(column);
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumnRange(column);
        switch (this.getColumnType(column)) {
            case 1: {
                return 1;
            }
            case 12: {
                return 65500;
            }
        }
        return 20;
    }

    @Override
    @Unsafe
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.getColumnName(column);
    }

    @Override
    @Unsafe
    public String getColumnName(int column) throws SQLException {
        this.checkColumnRange(column);
        return this.getColumn(column).getName().get();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumnRange(column);
        switch (this.getColumnType(column)) {
            case 16: {
                return 1;
            }
            case -6: {
                return 4;
            }
            case 91: 
            case 93: {
                return 32;
            }
            case 8: {
                return 64;
            }
            case 4: 
            case 6: {
                return 32;
            }
            case 5: {
                return 16;
            }
            case 1: {
                return 8;
            }
            case 3: {
                return this.getColumn(column).getPrecision().orElse(10);
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) {
        return this.getColumn(column).getScale().orElse(0);
    }

    @Override
    public String getTableName(int _column) {
        return "";
    }

    @Override
    public String getSchemaName(int _column) {
        return "";
    }

    @Override
    public String getCatalogName(int _column) {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnRange(column);
        return JdbcTypeUtils.jdbcTypeForFoundryFieldSchema(this.getColumn(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumnRange(column);
        return JdbcTypeUtils.typeNameForFoundryFieldSchema(this.getColumn(column));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnRange(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumnRange(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnRange(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkColumnRange(column);
        return JdbcTypeUtils.jdbcClassNameForFoundryFieldSchema(this.getColumn(column).getType());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    private void checkColumnRange(int column) throws SQLException {
        if (column <= 0 || column > this.getColumnCount()) {
            throw new SQLException("Invalid column index :" + column);
        }
    }

    private FoundryFieldSchema getColumn(int column) {
        return this.columnTypes.get(column - 1);
    }
}

