/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.results;

import com.palantir.foundry.sql.driver.exception.UncheckedSqlException;
import com.palantir.foundry.sql.driver.results.AutoCloseableIterator;
import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.jdbc.results.JdbcDriverRow;
import com.palantir.foundry.sql.jdbc.utils.JdbcDateUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;

public final class JdbcDriverRowIterator
implements JdbcDriverRow,
AutoCloseableIterator<JdbcDriverRow> {
    private final AutoCloseableIterator<DriverRow> internalRows;
    private final List<JdbcColumnConverter> accessors;
    private DriverRow current;
    private boolean lastValueReadWasNull;

    public JdbcDriverRowIterator(AutoCloseableIterator<DriverRow> internalRows, List<FoundryFieldSchema> schema) {
        this.internalRows = internalRows;
        JdbcColumnConverterFactory columnVisitor = new JdbcColumnConverterFactory();
        this.accessors = schema.stream().map(col -> col.getType().accept(columnVisitor)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public int numFields() {
        return this.current.numFields();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.current.isNullAt(ordinal - 1);
    }

    @Override
    public boolean lastValueReadWasNull() {
        return this.lastValueReadWasNull;
    }

    @Override
    public Object getObject(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.converter(ordinal).getObject(ordinal - 1);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.current.getBinary(ordinal - 1);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        this.setIsNull(ordinal);
        return !this.lastValueReadWasNull && this.current.getBoolean(ordinal - 1);
    }

    @Override
    public byte getByte(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? (byte)0 : this.current.getByte(ordinal - 1);
    }

    @Override
    public Date getSqlDate(int ordinal, Optional<Calendar> calendar) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.converter(ordinal).getSqlDate(ordinal - 1, calendar);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.current.getDecimal(ordinal - 1);
    }

    @Override
    public double getDouble(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? 0.0 : this.current.getDouble(ordinal - 1);
    }

    @Override
    public float getFloat(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? 0.0f : this.current.getFloat(ordinal - 1);
    }

    @Override
    public int getInteger(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? 0 : this.current.getInteger(ordinal - 1);
    }

    @Override
    public long getLong(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? 0L : this.current.getLong(ordinal - 1);
    }

    @Override
    public short getShort(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? (short)0 : this.current.getShort(ordinal - 1);
    }

    @Override
    public String getString(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.current.getString(ordinal - 1);
    }

    @Override
    public Timestamp getSqlTimestamp(int ordinal, Optional<Calendar> calendar) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.converter(ordinal).getSqlTimestamp(ordinal - 1, calendar);
    }

    @Override
    public String getArray(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.current.getArray(ordinal - 1);
    }

    @Override
    public String getMap(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.current.getMap(ordinal - 1);
    }

    @Override
    public String getStruct(int ordinal) {
        this.setIsNull(ordinal);
        return this.lastValueReadWasNull ? null : this.current.getStruct(ordinal - 1);
    }

    @Override
    public boolean hasNext() {
        return this.internalRows.hasNext();
    }

    @Override
    public JdbcDriverRow next() {
        this.current = (DriverRow)this.internalRows.next();
        return this;
    }

    private void setIsNull(int ordinal) {
        this.lastValueReadWasNull = this.isNullAt(ordinal);
    }

    @Override
    public void close() {
        this.internalRows.close();
    }

    private JdbcColumnConverter converter(int ordinal) {
        return this.accessors.get(ordinal - 1);
    }

    private final class JdbcColumnConverterFactory
    implements FoundryFieldType.Visitor<JdbcColumnConverter> {
        private JdbcColumnConverterFactory() {
        }

        @Override
        public JdbcColumnConverter visitArray() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitDecimal() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitMap() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitStruct() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitLong() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitBinary() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitBoolean() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitByte() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitDate() {
            return new DateJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitDouble() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitFloat() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitInteger() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitShort() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitString() {
            return new DefaultJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitTimestamp() {
            return new TimestampJdbcColumnConverter();
        }

        @Override
        public JdbcColumnConverter visitUnknown(String unknownValue) {
            throw new UncheckedSqlException("Unsupported column type: " + unknownValue);
        }
    }

    private final class TimestampJdbcColumnConverter
    extends JdbcColumnConverter {
        private TimestampJdbcColumnConverter() {
        }

        @Override
        Object getObject(int colIndex) {
            return this.getSqlTimestamp(colIndex, Optional.empty());
        }

        @Override
        Timestamp getSqlTimestamp(int colIndex, Optional<Calendar> calendar) {
            return JdbcDateUtils.toJdbcTimestamp(JdbcDriverRowIterator.this.current.getInstant(colIndex), calendar);
        }
    }

    private final class DateJdbcColumnConverter
    extends JdbcColumnConverter {
        private DateJdbcColumnConverter() {
        }

        @Override
        Object getObject(int colIndex) {
            return this.getSqlDate(colIndex, Optional.empty());
        }

        @Override
        Date getSqlDate(int colIndex, Optional<Calendar> calendar) {
            return JdbcDateUtils.toJdbcDate(JdbcDriverRowIterator.this.current.getDate(colIndex), calendar);
        }
    }

    private final class DefaultJdbcColumnConverter
    extends JdbcColumnConverter {
        private DefaultJdbcColumnConverter() {
        }

        @Override
        Object getObject(int colIndex) {
            return JdbcDriverRowIterator.this.current.getObject(colIndex);
        }
    }

    private static abstract class JdbcColumnConverter {
        private JdbcColumnConverter() {
        }

        Object getObject(int _colIndex) {
            throw new UnsupportedOperationException();
        }

        Date getSqlDate(int _colIndex, Optional<Calendar> _calendar) {
            throw new UnsupportedOperationException();
        }

        Timestamp getSqlTimestamp(int _colIndex, Optional<Calendar> _calendar) {
            throw new UnsupportedOperationException();
        }
    }
}

