/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.utils;

import com.palantir.logsafe.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Optional;
import java.util.TimeZone;

public final class JdbcDateUtils {
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public static Date toJdbcDate(LocalDate localDate, Optional<Calendar> maybeCal) {
        ZoneId timezone = maybeCal.map(cal -> cal.getTimeZone().toZoneId()).orElseGet(ZoneId::systemDefault);
        return new Date(localDate.atStartOfDay(timezone).toInstant().toEpochMilli());
    }

    public static Timestamp toJdbcTimestamp(Instant instant, Optional<Calendar> maybeCal) {
        Calendar calendar = maybeCal.orElse(UTC_CALENDAR);
        Preconditions.checkArgument(calendar.getTimeZone().toZoneId().getId().equals("UTC"), "A UTC calendar must be specified for timestamps");
        return Timestamp.from(instant);
    }

    private JdbcDateUtils() {
    }
}

