/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.utils;

import com.palantir.foundry.sql.driver.results.DriverRow;
import com.palantir.foundry.sql.driver.results.GenericDriverRow;
import com.palantir.foundry.sql.jdbc.results.FoundryJdbcResultSet;
import com.palantir.logsafe.Preconditions;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;

public final class JdbcTypeUtils {
    public static final int DEFAULT_MAX_STRING_SIZE = 65500;
    private static final List<FoundryFieldType> VAR_CHAR_TYPES = Arrays.asList(FoundryFieldType.STRING, FoundryFieldType.ARRAY, FoundryFieldType.MAP, FoundryFieldType.STRUCT);
    private static final ImmutableList<FoundryFieldSchema> COLUMNS_SCHEMA = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(JdbcTypeUtils.createStringField("TABLE_CAT"))).add(JdbcTypeUtils.createStringField("TABLE_SCHEM"))).add(JdbcTypeUtils.createStringField("TABLE_NAME"))).add(JdbcTypeUtils.createStringField("COLUMN_NAME"))).add(JdbcTypeUtils.createIntegerField("DATA_TYPE"))).add(JdbcTypeUtils.createStringField("TYPE_NAME"))).add(JdbcTypeUtils.createIntegerField("COLUMN_SIZE"))).add(JdbcTypeUtils.createIntegerField("BUFFER_LENGTH"))).add(JdbcTypeUtils.createIntegerField("DECIMAL_DIGITS"))).add(JdbcTypeUtils.createIntegerField("NUM_PREC_RADIX"))).add(JdbcTypeUtils.createIntegerField("NULLABLE"))).add(JdbcTypeUtils.createStringField("REMARKS"))).add(JdbcTypeUtils.createStringField("COLUMN_DEF"))).add(JdbcTypeUtils.createIntegerField("SQL_DATA_TYPE"))).add(JdbcTypeUtils.createIntegerField("SQL_DATETIME_SUB"))).add(JdbcTypeUtils.createIntegerField("CHAR_OCTET_LENGTH"))).add(JdbcTypeUtils.createIntegerField("ORDINAL_POSITION"))).add(JdbcTypeUtils.createStringField("IS_NULLABLE"))).add(JdbcTypeUtils.createStringField("SCOPE_CATALOG"))).add(JdbcTypeUtils.createStringField("SCOPE_SCHEMA"))).add(JdbcTypeUtils.createStringField("SCOPE_TABLE"))).add(JdbcTypeUtils.createShortField("SOURCE_DATA_TYPE"))).add(JdbcTypeUtils.createStringField("IS_AUTOINCREMENT"))).add(JdbcTypeUtils.createStringField("IS_GENERATEDCOLUMN"))).build();
    private static final ImmutableMap<FoundryFieldType, Integer> FOUNDRY_TO_JDBC_TYPE = ImmutableMap.builder().put(FoundryFieldType.DECIMAL, 3).put(FoundryFieldType.LONG, -5).put(FoundryFieldType.BINARY, -2).put(FoundryFieldType.BOOLEAN, 16).put(FoundryFieldType.BYTE, -6).put(FoundryFieldType.DATE, 91).put(FoundryFieldType.DOUBLE, 8).put(FoundryFieldType.FLOAT, 6).put(FoundryFieldType.INTEGER, 4).put(FoundryFieldType.SHORT, 5).put(FoundryFieldType.STRING, 12).put(FoundryFieldType.TIMESTAMP, 93).put(FoundryFieldType.ARRAY, 12).put(FoundryFieldType.MAP, 12).put(FoundryFieldType.STRUCT, 12).buildOrThrow();
    private static final ImmutableMap<FoundryFieldType, Class<?>> FOUNDRY_TO_JDBC_CLASS = ImmutableMap.builder().put(FoundryFieldType.DECIMAL, BigDecimal.class).put(FoundryFieldType.LONG, Long.class).put(FoundryFieldType.BINARY, byte[].class).put(FoundryFieldType.BOOLEAN, Boolean.class).put(FoundryFieldType.BYTE, Byte.class).put(FoundryFieldType.DATE, Date.class).put(FoundryFieldType.DOUBLE, Double.class).put(FoundryFieldType.FLOAT, Float.class).put(FoundryFieldType.INTEGER, Integer.class).put(FoundryFieldType.SHORT, Short.class).put(FoundryFieldType.STRING, String.class).put(FoundryFieldType.TIMESTAMP, Timestamp.class).put(FoundryFieldType.ARRAY, String.class).put(FoundryFieldType.MAP, String.class).put(FoundryFieldType.STRUCT, String.class).buildOrThrow();

    private JdbcTypeUtils() {
    }

    public static String typeNameForFoundryFieldSchema(FoundryFieldSchema fieldSchema) {
        return fieldSchema.getType().toString();
    }

    public static int jdbcTypeForFoundryFieldSchema(FoundryFieldSchema fieldSchema) throws SQLException {
        FoundryFieldType type = fieldSchema.getType();
        if (!FOUNDRY_TO_JDBC_TYPE.containsKey(type)) {
            throw new SQLException("Unknown type: " + String.valueOf(type));
        }
        return Preconditions.checkNotNull(FOUNDRY_TO_JDBC_TYPE.get(type));
    }

    public static String jdbcClassNameForFoundryFieldSchema(FoundryFieldType type) throws SQLException {
        if (!FOUNDRY_TO_JDBC_CLASS.containsKey(type)) {
            throw new SQLException("Unknown type: " + String.valueOf(type));
        }
        return Preconditions.checkNotNull(FOUNDRY_TO_JDBC_CLASS.get(type)).getName();
    }

    public static ResultSet foundryFieldsToColumnMetadata(Optional<String> catalogName, Optional<String> schemaName, String tableName, List<FoundryFieldSchema> fields) throws SQLException {
        ArrayList<DriverRow> resultSetRows = new ArrayList<DriverRow>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            FoundryFieldSchema fieldSchema = fields.get(i);
            resultSetRows.add(GenericDriverRow.of(catalogName.orElse(null), schemaName.orElse(null), tableName, fieldSchema.getName().get(), JdbcTypeUtils.jdbcTypeForFoundryFieldSchema(fieldSchema), JdbcTypeUtils.typeNameForFoundryFieldSchema(fieldSchema), JdbcTypeUtils.columnSizeForFoundryFieldSchema(fieldSchema), -1, fieldSchema.getScale().orElse(0), 10, 2, null, null, 0, 0, 128, i + 1, "YES", null, null, null, -1, "NO", "NO"));
        }
        return FoundryJdbcResultSet.of(COLUMNS_SCHEMA, resultSetRows);
    }

    private static FoundryFieldSchema createIntegerField(String name) {
        return JdbcTypeUtils.createField(FoundryFieldType.INTEGER, name);
    }

    private static FoundryFieldSchema createShortField(String name) {
        return JdbcTypeUtils.createField(FoundryFieldType.SHORT, name);
    }

    private static FoundryFieldSchema createStringField(String name) {
        return JdbcTypeUtils.createField(FoundryFieldType.STRING, name);
    }

    private static FoundryFieldSchema createField(FoundryFieldType type, String name) {
        return FoundryFieldSchema.builder().type(type).name(name).build();
    }

    private static int columnSizeForFoundryFieldSchema(FoundryFieldSchema fieldSchema) {
        if (VAR_CHAR_TYPES.contains(fieldSchema.getType())) {
            return 65500;
        }
        return fieldSchema.getPrecision().orElse(10);
    }
}

