/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.jdbc.utils;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.os.utils.SystemUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;

public final class TempDirectoryUtils {
    private static final Logger log = DriverLoggerFactory.getLogger(TempDirectoryUtils.class);
    private static final String LIBZSTD_PREFIX = "libzstd-jni";

    public static void cleanupTempLibFiles(Path temporaryDirectory) {
        if (!SystemUtils.isWindows()) {
            return;
        }
        try {
            TempDirectoryUtils.cleanupTempImpl(temporaryDirectory, LIBZSTD_PREFIX, Duration.ofMinutes(5L));
        }
        catch (Exception e) {
            log.debug("Failed cleaning up temp dir", e);
        }
    }

    @VisibleForTesting
    static void cleanupTempImpl(Path temporaryDirectory, String fileNamePrefix, Duration olderThan) throws IOException {
        List<Path> oldZstdFiles = TempDirectoryUtils.listOldFiles(temporaryDirectory, fileNamePrefix, olderThan);
        for (Path file : oldZstdFiles) {
            try {
                Files.deleteIfExists(file);
            }
            catch (Exception e) {
                log.debug("Failed deleting temp file", e);
            }
        }
    }

    private static List<Path> listOldFiles(Path dir, String fileNamePrefix, Duration olderThan) throws IOException {
        try (Stream<Path> dirStream = Files.list(dir);){
            List<Path> list = dirStream.filter(f -> f.getFileName().toString().startsWith(fileNamePrefix)).filter(f -> TempDirectoryUtils.isFileOlderThan(f, olderThan)).collect(Collectors.toList());
            return list;
        }
    }

    private static boolean isFileOlderThan(Path file, Duration olderThan) {
        try {
            FileTime creationTime = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime();
            return Instant.ofEpochMilli(creationTime.toMillis()).isBefore(Instant.now().minus(olderThan));
        }
        catch (IOException e) {
            log.debug("Exception reading temp file attributes", e);
            return true;
        }
    }

    private TempDirectoryUtils() {
    }
}

