/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.client;

import com.palantir.foundry.sql.multipass.oauth.client.MultipassOAuth2Service;
import com.palantir.foundry.sql.multipass.oauth.client.TokenResponse;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;

public final class ClientCredentialsProvider {
    private final String clientId;
    private final String clientSecret;
    private final MultipassOAuth2Service oAuth2Service;

    public ClientCredentialsProvider(String clientId, String clientSecret, MultipassOAuth2Service oAuth2Service) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.oAuth2Service = oAuth2Service;
    }

    public TokenResponse get() {
        ImmutableMap<String, String> tokenArgs = ImmutableMap.builder().put("grant_type", "client_credentials").put("client_id", this.clientId).put("client_secret", this.clientSecret).put("scope", "foundry-sql-server:query").buildOrThrow();
        return this.oAuth2Service.token(tokenArgs);
    }
}

