/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.client;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import shadow.palantir.driver.com.palantir.dialogue.RequestBody;

final class FormUrlEncodedRequestBody
implements RequestBody {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private final Map<String, String> map;

    FormUrlEncodedRequestBody(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        boolean first = true;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                output.write(38);
            }
            Preconditions.checkArgument(entry.getKey() != null, "key must not be null");
            String key = URLEncoder.encode(entry.getKey(), UTF_8);
            output.write(key.getBytes(StandardCharsets.UTF_8));
            output.write(61);
            Preconditions.checkArgument(entry.getValue() != null, "value must not be null", UnsafeArg.of("key", entry.getKey()));
            String value = URLEncoder.encode(entry.getValue(), UTF_8);
            output.write(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public String contentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public boolean repeatable() {
        return true;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "FormUrlEncodedRequestBody{map.keySet=" + String.valueOf(this.map.keySet()) + "}";
    }
}

