/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.client;

import com.palantir.foundry.sql.multipass.oauth.client.CheckTokenResponse;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckTokenResponse", generator="Immutables")
@Immutable
public final class ImmutableCheckTokenResponse
extends CheckTokenResponse {
    private final String clientId;
    private final String grantType;

    private ImmutableCheckTokenResponse(String clientId, String grantType) {
        this.clientId = clientId;
        this.grantType = grantType;
    }

    @Override
    @JsonProperty(value="client_id")
    public String clientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grant_type")
    public String grantType() {
        return this.grantType;
    }

    public final ImmutableCheckTokenResponse withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckTokenResponse(newValue, this.grantType);
    }

    public final ImmutableCheckTokenResponse withGrantType(String value) {
        String newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckTokenResponse(this.clientId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckTokenResponse && this.equalsByValue((ImmutableCheckTokenResponse)another);
    }

    private boolean equalsByValue(ImmutableCheckTokenResponse another) {
        return this.clientId.equals(another.clientId) && this.grantType.equals(another.grantType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.grantType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CheckTokenResponse").omitNullValues().add("clientId", this.clientId).add("grantType", this.grantType).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckTokenResponse fromJson(Json json) {
        CheckTokenResponse.Builder builder = new CheckTokenResponse.Builder();
        if (json._clientId != null) {
            builder.clientId(json._clientId);
        }
        if (json._grantType != null) {
            builder.grantType(json._grantType);
        }
        return builder.build();
    }

    public static ImmutableCheckTokenResponse copyOf(CheckTokenResponse instance) {
        if (instance instanceof ImmutableCheckTokenResponse) {
            return (ImmutableCheckTokenResponse)instance;
        }
        return new CheckTokenResponse.Builder().from(instance).build();
    }

    @Generated(from="CheckTokenResponse", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_GRANT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String clientId;
        @Nullable
        private String grantType;

        public Builder() {
            if (!(this instanceof CheckTokenResponse.Builder)) {
                throw new UnsupportedOperationException("Use: new CheckTokenResponse.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final CheckTokenResponse.Builder from(CheckTokenResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            this.grantType(instance.grantType());
            return (CheckTokenResponse.Builder)this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final CheckTokenResponse.Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CheckTokenResponse.Builder)this;
        }

        @JsonProperty(value="grant_type")
        @CanIgnoreReturnValue
        public final CheckTokenResponse.Builder grantType(String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CheckTokenResponse.Builder)this;
        }

        public ImmutableCheckTokenResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckTokenResponse(this.clientId, this.grantType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("grantType");
            }
            return "Cannot build CheckTokenResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="CheckTokenResponse", generator="Immutables")
    static final class Json
    extends CheckTokenResponse {
        @JsonIgnore
        @Nullable
        String _clientId;
        @JsonIgnore
        @Nullable
        String _grantType;

        Json() {
        }

        @JsonProperty(value="client_id")
        public void setClientId(String clientId) {
            this._clientId = clientId;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(String grantType) {
            this._grantType = grantType;
        }

        @Override
        public String clientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String grantType() {
            throw new UnsupportedOperationException();
        }
    }
}

