/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.client;

import com.palantir.foundry.sql.multipass.oauth.client.TokenResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TokenResponse", generator="Immutables")
@Immutable
public final class ImmutableTokenResponse
implements TokenResponse {
    private final BearerToken accessToken;
    @Nullable
    private final BearerToken refreshToken;
    private final Duration expiresIn;

    private ImmutableTokenResponse(BearerToken accessToken, @Nullable BearerToken refreshToken, Duration expiresIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
    }

    @Override
    @JsonProperty(value="access_token")
    public BearerToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    @JsonProperty(value="refresh_token")
    public Optional<BearerToken> getRefreshToken() {
        return Optional.ofNullable(this.refreshToken);
    }

    @Override
    @JsonProperty(value="expires_in")
    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    public final ImmutableTokenResponse withAccessToken(BearerToken value) {
        if (this.accessToken == value) {
            return this;
        }
        BearerToken newValue = Objects.requireNonNull(value, "accessToken");
        return new ImmutableTokenResponse(newValue, this.refreshToken, this.expiresIn);
    }

    public final ImmutableTokenResponse withRefreshToken(BearerToken value) {
        BearerToken newValue = Objects.requireNonNull(value, "refreshToken");
        if (this.refreshToken == newValue) {
            return this;
        }
        return new ImmutableTokenResponse(this.accessToken, newValue, this.expiresIn);
    }

    public final ImmutableTokenResponse withRefreshToken(Optional<? extends BearerToken> optional) {
        BearerToken value = optional.orElse(null);
        if (this.refreshToken == value) {
            return this;
        }
        return new ImmutableTokenResponse(this.accessToken, value, this.expiresIn);
    }

    public final ImmutableTokenResponse withExpiresIn(Duration value) {
        if (this.expiresIn == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "expiresIn");
        return new ImmutableTokenResponse(this.accessToken, this.refreshToken, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenResponse && this.equalsByValue((ImmutableTokenResponse)another);
    }

    private boolean equalsByValue(ImmutableTokenResponse another) {
        return this.accessToken.equals(another.accessToken) && Objects.equals(this.refreshToken, another.refreshToken) && this.expiresIn.equals(another.expiresIn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessToken.hashCode();
        h += (h << 5) + Objects.hashCode(this.refreshToken);
        h += (h << 5) + this.expiresIn.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TokenResponse").omitNullValues().add("accessToken", this.accessToken).add("refreshToken", this.refreshToken).add("expiresIn", this.expiresIn).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTokenResponse fromJson(Json json) {
        TokenResponse.Builder builder = new TokenResponse.Builder();
        if (json._accessToken != null) {
            builder.accessToken(json._accessToken);
        }
        if (json._refreshToken != null) {
            builder.refreshToken(json._refreshToken);
        }
        if (json._expiresIn != null) {
            builder.expiresIn(json._expiresIn);
        }
        return builder.build();
    }

    public static ImmutableTokenResponse copyOf(TokenResponse instance) {
        if (instance instanceof ImmutableTokenResponse) {
            return (ImmutableTokenResponse)instance;
        }
        return new TokenResponse.Builder().from(instance).build();
    }

    @Generated(from="TokenResponse", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_ACCESS_TOKEN = 1L;
        private static final long INIT_BIT_EXPIRES_IN = 2L;
        private long initBits = 3L;
        @Nullable
        private BearerToken accessToken;
        @Nullable
        private BearerToken refreshToken;
        @Nullable
        private Duration expiresIn;

        public Builder() {
            if (!(this instanceof TokenResponse.Builder)) {
                throw new UnsupportedOperationException("Use: new TokenResponse.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final TokenResponse.Builder from(TokenResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessToken(instance.getAccessToken());
            Optional<BearerToken> refreshTokenOptional = instance.getRefreshToken();
            if (refreshTokenOptional.isPresent()) {
                this.refreshToken(refreshTokenOptional);
            }
            this.expiresIn(instance.getExpiresIn());
            return (TokenResponse.Builder)this;
        }

        @JsonProperty(value="access_token")
        @CanIgnoreReturnValue
        public final TokenResponse.Builder accessToken(BearerToken accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (TokenResponse.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TokenResponse.Builder refreshToken(BearerToken refreshToken) {
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            return (TokenResponse.Builder)this;
        }

        @JsonProperty(value="refresh_token")
        @CanIgnoreReturnValue
        public final TokenResponse.Builder refreshToken(Optional<? extends BearerToken> refreshToken) {
            this.refreshToken = refreshToken.orElse(null);
            return (TokenResponse.Builder)this;
        }

        @JsonProperty(value="expires_in")
        @CanIgnoreReturnValue
        public final TokenResponse.Builder expiresIn(Duration expiresIn) {
            this.expiresIn = Objects.requireNonNull(expiresIn, "expiresIn");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (TokenResponse.Builder)this;
        }

        public ImmutableTokenResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokenResponse(this.accessToken, this.refreshToken, this.expiresIn);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessToken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expiresIn");
            }
            return "Cannot build TokenResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="TokenResponse", generator="Immutables")
    static final class Json
    implements TokenResponse {
        @JsonIgnore
        @Nullable
        BearerToken _accessToken;
        @JsonIgnore
        @Nullable
        Optional<BearerToken> _refreshToken = Optional.empty();
        @JsonIgnore
        @Nullable
        Duration _expiresIn;

        Json() {
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(BearerToken accessToken) {
            this._accessToken = accessToken;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshToken(Optional<BearerToken> refreshToken) {
            this._refreshToken = refreshToken;
        }

        @JsonProperty(value="expires_in")
        public void setExpiresIn(Duration expiresIn) {
            this._expiresIn = expiresIn;
        }

        @Override
        public BearerToken getAccessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BearerToken> getRefreshToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getExpiresIn() {
            throw new UnsupportedOperationException();
        }
    }
}

