/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.client;

import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.HttpMethod;
import shadow.palantir.driver.com.palantir.dialogue.PathTemplate;
import shadow.palantir.driver.com.palantir.dialogue.UrlBuilder;

enum MultipassOAuth2Endpoints implements Endpoint
{
    checkToken{
        private final PathTemplate pathTemplate = PathTemplate.builder().fixed("oauth2").fixed("check_token").build();

        @Override
        public void renderPath(Map<String, String> params, UrlBuilder url) {
            this.pathTemplate.fill(params, url);
        }

        @Override
        public HttpMethod httpMethod() {
            return HttpMethod.GET;
        }

        @Override
        public String serviceName() {
            return "CheckTokenService";
        }

        @Override
        public String endpointName() {
            return "checkToken";
        }

        @Override
        public String version() {
            return VERSION;
        }
    }
    ,
    token{
        private final PathTemplate pathTemplate = PathTemplate.builder().fixed("oauth2").fixed("token").build();

        @Override
        public void renderPath(Map<String, String> params, UrlBuilder url) {
            this.pathTemplate.fill(params, url);
        }

        @Override
        public HttpMethod httpMethod() {
            return HttpMethod.POST;
        }

        @Override
        public String serviceName() {
            return "MultipassOAuth2Service";
        }

        @Override
        public String endpointName() {
            return "token";
        }

        @Override
        public String version() {
            return VERSION;
        }
    };

    private static final String VERSION;

    static {
        VERSION = Optional.ofNullable(MultipassOAuth2Endpoints.class.getPackage().getImplementationVersion()).orElse("0.0.0");
    }
}

