/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.client;

import com.palantir.foundry.sql.multipass.oauth.client.CheckTokenResponse;
import com.palantir.foundry.sql.multipass.oauth.client.FormUrlEncodedRequestBody;
import com.palantir.foundry.sql.multipass.oauth.client.MultipassOAuth2Endpoints;
import com.palantir.foundry.sql.multipass.oauth.client.TokenResponse;
import java.util.Map;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

public interface MultipassOAuth2Service {
    public CheckTokenResponse checkToken(AuthHeader var1);

    public TokenResponse token(Map<String, String> var1);

    public static MultipassOAuth2Service of(final Channel channel, final ConjureRuntime runtime) {
        return new MultipassOAuth2Service(){
            private final EndpointChannel checkTokenChannel;
            private final Deserializer<CheckTokenResponse> checkTokenDeserializer;
            private final EndpointChannel tokenChannel;
            private final Deserializer<TokenResponse> tokenDeserializer;
            {
                this.checkTokenChannel = runtime.clients().bind(channel, MultipassOAuth2Endpoints.checkToken);
                this.checkTokenDeserializer = runtime.bodySerDe().deserializer(new TypeMarker<CheckTokenResponse>(){});
                this.tokenChannel = runtime.clients().bind(channel, MultipassOAuth2Endpoints.token);
                this.tokenDeserializer = runtime.bodySerDe().deserializer(new TypeMarker<TokenResponse>(){});
            }

            @Override
            public CheckTokenResponse checkToken(AuthHeader authHeader) {
                Request.Builder request = Request.builder();
                request.putHeaderParams("Authorization", authHeader.toString());
                return runtime.clients().callBlocking(this.checkTokenChannel, request.build(), this.checkTokenDeserializer);
            }

            @Override
            public TokenResponse token(Map<String, String> tokenRequest) {
                Request request = Request.builder().body(new FormUrlEncodedRequestBody(tokenRequest)).build();
                return runtime.clients().callBlocking(this.tokenChannel, request, this.tokenDeserializer);
            }
        };
    }
}

