/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.flow;

import com.palantir.foundry.sql.multipass.oauth.client.MultipassOAuth2Service;
import com.palantir.foundry.sql.multipass.oauth.client.TokenResponse;
import com.palantir.foundry.sql.multipass.oauth.flow.OAuthCallBackServer;
import com.palantir.foundry.sql.multipass.oauth.flow.WindowsBrowser;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.hash.HashFunction;
import shadow.palantir.driver.com.google.common.hash.Hashing;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;
import shadow.palantir.driver.org.apache.hc.core5.net.URIBuilder;

public final class FoundryOAuthFlow {
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static final String GRANT_TYPE_KEY = "grant_type";
    private static final String REFRESH_TOKEN_KEY = "refresh_token";
    private static final String CODE_VERIFIER_KEY = "code_verifier";
    private static final String AUTHORIZATION_CODE_KEY = "code";
    private static final String REDIRECT_URI_KEY = "redirect_uri";
    private static final String TOKEN_SCOPE_KEY = "scope";
    private static final String STATE_KEY = "state";
    private static final String CODE_CHALLENGE_METHOD_KEY = "code_challenge_method";
    private static final String CODE_CHALLENGE_KEY = "code_challenge";
    private static final String RESPONSE_TYPE_KEY = "response_type";
    private static final String REDIRECT_HOST = "http://127.0.0.1";
    private static final String REDIRECT_PATH = "/foundrydriver/oauthredirect";
    private static final String TOKEN_SCOPE = "foundry-sql-server:query offline_access";
    private static final String CODE_CHALLENGE_METHOD = "S256";
    private static final String RESPONSE_TYPE = "code";
    private static final String AUTHORIZE_GRANT_TYPE = "authorization_code";
    private static final String REFRESH_GRANT_TYPE = "refresh_token";
    private static final HashFunction CODE_CHALLENGE_HASHER = Hashing.sha256();
    private static final Base64.Encoder CODE_CHALLENGE_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final String clientId;
    private final Optional<String> clientSecret;
    private final String authorizeEndpoint;
    private final int redirectPort;
    private final String redirectUri;
    private final MultipassOAuth2Service oAuth2Service;
    private final Supplier<String> stateSupplier;

    public FoundryOAuthFlow(String clientId, Optional<String> clientSecret, String authorizeEndpoint, int redirectPort, MultipassOAuth2Service oAuth2Service, Supplier<String> stateSupplier) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authorizeEndpoint = authorizeEndpoint;
        this.redirectPort = redirectPort;
        this.redirectUri = String.format("%s:%s%s", REDIRECT_HOST, redirectPort, REDIRECT_PATH);
        this.oAuth2Service = oAuth2Service;
        this.stateSupplier = stateSupplier;
    }

    public TokenResponse refresh(BearerToken refreshToken) {
        ImmutableMap.Builder<String, String> tokenArgsBuilder = ImmutableMap.builder().put(CLIENT_ID_KEY, this.clientId).put(GRANT_TYPE_KEY, "refresh_token").put("refresh_token", refreshToken.getToken());
        this.clientSecret.ifPresent(secret -> tokenArgsBuilder.put(CLIENT_SECRET_KEY, (String)secret));
        return this.oAuth2Service.token(tokenArgsBuilder.buildOrThrow());
    }

    public TokenResponse freshOauthFlow() {
        String codeVerifier = UUID.randomUUID().toString() + String.valueOf(UUID.randomUUID());
        String authorizationCode = this.authorize(codeVerifier);
        return this.token(authorizationCode, codeVerifier);
    }

    private String authorize(String codeVerifier) {
        String state = this.stateSupplier.get();
        OAuthCallBackServer callBackServer = new OAuthCallBackServer(REDIRECT_PATH, this.redirectPort, state);
        try {
            URI authorizationUrl = FoundryOAuthFlow.buildAuthorizationUrl(this.clientId, this.authorizeEndpoint, this.redirectUri, codeVerifier, state);
            WindowsBrowser.browse(authorizationUrl);
            String string = callBackServer.awaitCallback();
            callBackServer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    callBackServer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SafeRuntimeException("Failed to authorize", (Throwable)e, new Arg[0]);
            }
        }
    }

    private TokenResponse token(String authorizationCode, String codeVerifier) {
        ImmutableMap.Builder<String, String> tokenRequestBuilder = ImmutableMap.builder().put(CLIENT_ID_KEY, this.clientId).put(GRANT_TYPE_KEY, AUTHORIZE_GRANT_TYPE).put(CODE_VERIFIER_KEY, codeVerifier).put("code", authorizationCode).put(REDIRECT_URI_KEY, this.redirectUri);
        this.clientSecret.ifPresent(secret -> tokenRequestBuilder.put(CLIENT_SECRET_KEY, (String)secret));
        return this.oAuth2Service.token(tokenRequestBuilder.buildOrThrow());
    }

    private static URI buildAuthorizationUrl(String clientId, String authorizeEndpoint, String redirectUri, String codeVerifier, String state) throws URISyntaxException {
        String codeChallenge = FoundryOAuthFlow.codeChallenge(codeVerifier);
        return new URIBuilder(authorizeEndpoint).addParameter(CLIENT_ID_KEY, clientId).addParameter(TOKEN_SCOPE_KEY, TOKEN_SCOPE).addParameter(STATE_KEY, state).addParameter(CODE_CHALLENGE_METHOD_KEY, CODE_CHALLENGE_METHOD).addParameter(CODE_CHALLENGE_KEY, codeChallenge).addParameter(REDIRECT_URI_KEY, redirectUri).addParameter(RESPONSE_TYPE_KEY, "code").build();
    }

    private static String codeChallenge(String codeVerifier) {
        byte[] hashed = CODE_CHALLENGE_HASHER.hashString(codeVerifier, StandardCharsets.UTF_8).asBytes();
        return new String(CODE_CHALLENGE_ENCODER.encode(hashed), StandardCharsets.UTF_8);
    }
}

