/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.flow;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.util.concurrent.MoreExecutors;
import shadow.palantir.driver.com.google.common.util.concurrent.SettableFuture;
import shadow.palantir.driver.org.apache.hc.core5.http.NameValuePair;
import shadow.palantir.driver.org.apache.hc.core5.net.URLEncodedUtils;

final class OAuthCallBackServer
implements AutoCloseable {
    private static final Logger log = DriverLoggerFactory.getLogger(OAuthCallBackServer.class);
    private static final String AUTHORIZATION_CODE_QUERY_PARAMETER = "code";
    private static final int AUTHORIZATION_TIMEOUT_MINUTES = 2;
    private static final int MAX_QUEUED_CONNECTIONS = 1;
    private static final String STATE_QUERY_PARAMETER = "state";
    @VisibleForTesting
    static final String AUTHORIZE_COMPLETE_HTML_RESPONSE = "<html><body>Please return to the app.</body></html>";
    private final SettableFuture<String> authorizationCode = SettableFuture.create();
    private final HttpServer server;
    private final String expectedState;

    OAuthCallBackServer(String redirectPath, int port, String expectedState) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), port), 1);
        this.expectedState = expectedState;
        this.server.createContext(redirectPath, new RedirectHandler());
        this.server.setExecutor(MoreExecutors.directExecutor());
        this.server.start();
    }

    String awaitCallback() throws SQLException {
        log.info("Awaiting OAuth callback");
        try {
            return (String)this.authorizationCode.get(2L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new SQLException("Timed out waiting for OAuth callback", e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted whilst waiting for OAuth callback", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Received an invalid callback: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        log.info("Stopping OAuth callback server");
        this.server.stop(0);
    }

    final class RedirectHandler
    implements HttpHandler {
        RedirectHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            Map<String, String> queryParams = URLEncodedUtils.parse(exchange.getRequestURI(), StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            exchange.sendResponseHeaders(200, OAuthCallBackServer.AUTHORIZE_COMPLETE_HTML_RESPONSE.length());
            try (OutputStream os = exchange.getResponseBody();){
                os.write(OAuthCallBackServer.AUTHORIZE_COMPLETE_HTML_RESPONSE.getBytes(StandardCharsets.UTF_8));
            }
            exchange.close();
            Optional<String> state = Optional.ofNullable(queryParams.get(OAuthCallBackServer.STATE_QUERY_PARAMETER));
            if (!state.isPresent()) {
                OAuthCallBackServer.this.authorizationCode.setException(new SafeRuntimeException("State not present", new Arg[0]));
            } else if (!OAuthCallBackServer.this.expectedState.equals(state.get())) {
                OAuthCallBackServer.this.authorizationCode.setException(new SafeRuntimeException("Received invalid state", new Arg[0]));
            }
            Optional<String> authCode = Optional.ofNullable(queryParams.get(OAuthCallBackServer.AUTHORIZATION_CODE_QUERY_PARAMETER));
            if (authCode.isPresent()) {
                OAuthCallBackServer.this.authorizationCode.set(authCode.get());
            } else {
                OAuthCallBackServer.this.authorizationCode.setException(new SafeRuntimeException("Authorization code not present", new Arg[0]));
            }
        }
    }
}

