/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.store;

import com.palantir.foundry.sql.multipass.oauth.store.CredentialStore;
import com.palantir.foundry.sql.multipass.oauth.store.WindowsCredentialStore;
import com.palantir.foundry.sql.os.utils.SystemUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;

public enum CredentialStoreFactory {
    INSTANCE;


    public CredentialStore get(String credentialNamePrefix, String oAuthClientId) {
        String credentialName = this.credentialName(credentialNamePrefix, oAuthClientId);
        if (SystemUtils.isWindows()) {
            return new WindowsCredentialStore(credentialName);
        }
        throw new SafeRuntimeException("OAuth is only supported on Windows", new Arg[0]);
    }

    @VisibleForTesting
    String credentialName(String credentialNamePrefix, String oauthClientId) {
        return String.format("%s-%s", credentialNamePrefix, oauthClientId);
    }
}

