/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.store;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.multipass.oauth.store.CredentialStore;
import com.palantir.foundry.sql.multipass.oauth.store.jna.WinCred;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;
import shadow.palantir.driver.com.sun.jna.LastErrorException;
import shadow.palantir.driver.com.sun.jna.Native;
import shadow.palantir.driver.com.sun.jna.ptr.PointerByReference;

final class WindowsCredentialStore
implements CredentialStore {
    private static final Logger log = DriverLoggerFactory.getLogger(WindowsCredentialStore.class);
    private static final Charset CREDENTIAL_ENCODING_CHARSET = StandardCharsets.UTF_8;
    private final String credentialName;

    WindowsCredentialStore(String credentialName) {
        this.credentialName = credentialName;
    }

    @Override
    public void put(BearerToken refreshToken) {
        byte[] credentialBytes = refreshToken.getToken().getBytes(CREDENTIAL_ENCODING_CHARSET);
        WinCred.Credential credential = WinCred.Credential.oauthCredential(this.credentialName, credentialBytes);
        try {
            WinCred.INSTANCE.CredWriteW(credential, 0);
            log.debug("Stored OAuth credentials");
        }
        catch (LastErrorException e) {
            log.error("Failed to write refresh token", e);
            throw e;
        }
    }

    @Override
    public Optional<BearerToken> get() {
        PointerByReference credentialPointer = new PointerByReference();
        try {
            WinCred.INSTANCE.CredReadW(this.credentialName, 1, 0, credentialPointer);
            WinCred.Credential credential = new WinCred.Credential(credentialPointer.getValue());
            if (credential.credentialBlobSize == 0) {
                throw new SafeRuntimeException("Stored refresh token is empty", new Arg[0]);
            }
            byte[] credentialBytes = credential.credentialBlob.getByteArray(0L, credential.credentialBlobSize);
            String refreshToken = new String(credentialBytes, CREDENTIAL_ENCODING_CHARSET);
            log.debug("Read OAuth credentials");
            Optional<BearerToken> optional = Optional.of(BearerToken.valueOf(refreshToken));
            return optional;
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() == 1168) {
                log.debug("Refresh token not found", e);
                Optional<BearerToken> optional = Optional.empty();
                return optional;
            }
            throw e;
        }
        finally {
            if (credentialPointer.getValue() != null) {
                WinCred.INSTANCE.CredFree(credentialPointer.getValue());
            }
        }
    }

    @Override
    public void clear() {
        boolean success = WinCred.INSTANCE.CredDeleteW(this.credentialName, 1, 0);
        if (success) {
            log.debug("Deleted stored OAuth credential");
        } else {
            log.warn("Failed to deleted stored OAuth credential - {}", (Object)UnsafeArg.of("nativeError", Native.getLastError()));
        }
    }
}

