/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.multipass.oauth.store.jna;

import com.palantir.foundry.sql.os.utils.SystemUtils;
import java.util.Arrays;
import java.util.List;
import shadow.palantir.driver.com.sun.jna.LastErrorException;
import shadow.palantir.driver.com.sun.jna.Memory;
import shadow.palantir.driver.com.sun.jna.Native;
import shadow.palantir.driver.com.sun.jna.Pointer;
import shadow.palantir.driver.com.sun.jna.Structure;
import shadow.palantir.driver.com.sun.jna.WString;
import shadow.palantir.driver.com.sun.jna.platform.win32.WinBase;
import shadow.palantir.driver.com.sun.jna.ptr.PointerByReference;
import shadow.palantir.driver.com.sun.jna.win32.StdCallLibrary;
import shadow.palantir.driver.com.sun.jna.win32.W32APIOptions;

public interface WinCred
extends StdCallLibrary {
    public static final WinCred INSTANCE = SystemUtils.isWindows() ? Native.load("Advapi32", WinCred.class, W32APIOptions.UNICODE_OPTIONS) : null;
    public static final int CREDENTIAL_TYPE_GENERIC = 1;
    public static final int CREDENTIAL_PERSIST_SESSION = 1;
    public static final int CREDENTIAL_PERSIST_LOCAL_MACHINE = 2;
    public static final int CREDENTIAL_PERSIST_ENTERPRISE = 3;
    public static final int READ_ERROR_NOT_FOUND = 1168;

    public boolean CredReadW(String var1, int var2, int var3, PointerByReference var4) throws LastErrorException;

    public boolean CredWriteW(Credential var1, int var2) throws LastErrorException;

    public boolean CredDeleteW(String var1, int var2, int var3);

    public void CredFree(Pointer var1) throws LastErrorException;

    public static class Credential
    extends Structure {
        public int flags;
        public int type;
        public WString targetName;
        public WString comment;
        public WinBase.FILETIME lastWritten = new WinBase.FILETIME();
        public int credentialBlobSize;
        public Pointer credentialBlob;
        public int persist;
        public int attributeCount;
        public Pointer attributes;
        public WString targetAlias;
        public WString userName;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("flags", "type", "targetName", "comment", "lastWritten", "credentialBlobSize", "credentialBlob", "persist", "attributeCount", "attributes", "targetAlias", "userName");
        }

        public Credential() {
        }

        public Credential(Pointer credentialPointer) {
            super(credentialPointer);
            this.read();
        }

        public static Credential oauthCredential(String credentialName, byte[] credentialBytes) {
            Memory credentialMem = new Memory(credentialBytes.length);
            credentialMem.write(0L, credentialBytes, 0, credentialBytes.length);
            Credential credential = new Credential();
            credential.type = 1;
            credential.targetName = new WString(credentialName);
            credential.credentialBlobSize = (int)credentialMem.size();
            credential.credentialBlob = credentialMem;
            credential.persist = 2;
            return credential;
        }
    }
}

