/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.os.utils;

import com.palantir.foundry.sql.os.utils.SystemUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Optional;

public final class FileUtils {
    private FileUtils() {
    }

    public static Path getJarFolder(Class<?> clazz) {
        return FileUtils.toFile(FileUtils.classLocation(clazz)).toPath().getParent();
    }

    private static URL classLocation(Class<?> clazz) {
        try {
            return Optional.ofNullable(clazz.getProtectionDomain().getCodeSource()).map(CodeSource::getLocation).orElseThrow(() -> new SafeRuntimeException("Failed to determine file system location", new Arg[0]));
        }
        catch (Exception e) {
            throw new SafeRuntimeException("Failed to determine file system location", (Throwable)e, new Arg[0]);
        }
    }

    private static File toFile(URL url) {
        Object path = url.toString();
        if (((String)path).startsWith("jar:")) {
            int index = ((String)path).indexOf("!/");
            path = ((String)path).substring("jar:".length(), index);
        }
        try {
            if (SystemUtils.isWindows() && ((String)path).matches("file:[A-Za-z]:.*")) {
                path = "file:/" + ((String)path).substring("file:".length());
            }
            return new File(new URL((String)path).toURI());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            if (((String)path).startsWith("file:")) {
                return new File(((String)path).substring("file:".length()));
            }
            throw new SafeRuntimeException("Couldn't parse URL to file path", UnsafeArg.of("url", url));
        }
    }
}

