/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.os.utils;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.os.utils.SystemUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.Streams;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.SslSocketFactories;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.TrustContext;
import shadow.palantir.driver.org.apache.commons.io.FileUtils;

public final class TrustStores {
    private static final Logger log = DriverLoggerFactory.getLogger(TrustStores.class);

    public static TrustContext loadCertificates(Optional<SslConfiguration> customCerts) {
        if (SystemUtils.isWindows()) {
            return TrustStores.loadCertificates(Optional.of(OsStoreId.WINDOWS), customCerts);
        }
        if (SystemUtils.isMac()) {
            return TrustStores.loadCertificates(Optional.of(OsStoreId.MAC), customCerts);
        }
        return TrustStores.loadCertificates(Optional.empty(), customCerts);
    }

    @VisibleForTesting
    static TrustContext loadCertificates(Optional<OsStoreId> osStoreId, Optional<SslConfiguration> maybeCustomCerts) {
        try {
            List<X509Certificate> customAndConjureCerts;
            Thread.currentThread().setContextClassLoader(TrustStores.class.getClassLoader());
            KeyStore combinedKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
            combinedKeystore.load(null, null);
            List osCerts = osStoreId.isPresent() ? TrustStores.tryLoadOsCerts(osStoreId.get().storeId) : List.of();
            List<X509Certificate> jreCerts = TrustStores.loadJreTrustStoreCertificates();
            if (maybeCustomCerts.isPresent()) {
                customAndConjureCerts = TrustStores.loadCustomAndDefaultConjureCertificates(maybeCustomCerts.get());
            } else {
                Path emptyFilePath = TrustStores.createEmptyPemFile();
                customAndConjureCerts = TrustStores.loadCustomAndDefaultConjureCertificates(SslConfiguration.of(emptyFilePath));
                FileUtils.deleteQuietly(emptyFilePath.toFile());
            }
            List allCerts = Streams.concat(osCerts.stream(), jreCerts.stream(), customAndConjureCerts.stream()).distinct().collect(Collectors.toList());
            log.info("Loaded {} unique certs", (Object)SafeArg.of("numUniqueCerts", allCerts.size()));
            for (int i = 0; i < allCerts.size(); ++i) {
                combinedKeystore.setCertificateEntry("cert-" + i, (Certificate)allCerts.get(i));
            }
            X509TrustManager trustManager = TrustStores.createX509TrustManager(combinedKeystore);
            SSLSocketFactory socketFactory = TrustStores.createSslSocketFactory(trustManager);
            return TrustContext.of(socketFactory, trustManager);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SafeRuntimeException("Failed to build trust store", (Throwable)e, new Arg[0]);
        }
    }

    private static List<X509Certificate> loadCustomAndDefaultConjureCertificates(SslConfiguration customCerts) {
        log.info("Loading custom certificates: {}", (Object)UnsafeArg.of("certificatesPath", customCerts.trustStorePath()));
        X509Certificate[] customX509Certificates = SslSocketFactories.createX509TrustManager(customCerts).getAcceptedIssuers();
        log.debug("Loaded custom and default certificates: {}", (Object)UnsafeArg.of("certificates", Arrays.stream(customX509Certificates).map(cert -> cert.getSubjectX500Principal().getName()).collect(Collectors.toList())));
        return Arrays.asList(customX509Certificates);
    }

    private static List<X509Certificate> loadJreTrustStoreCertificates() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            List<TrustManager> defaultTrustManagers = Arrays.asList(tmf.getTrustManagers());
            List<X509Certificate> jreCerts = defaultTrustManagers.stream().filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).flatMap(trustManager -> Arrays.stream(trustManager.getAcceptedIssuers())).collect(Collectors.toList());
            log.debug("Loaded JRE truststore certificates: {}", (Object)UnsafeArg.of("certificates", jreCerts.stream().map(cert -> cert.getSubjectX500Principal().getName()).collect(Collectors.toList())));
            return jreCerts;
        }
        catch (Exception e) {
            log.warn("Failed to load JRE truststore. Will continue without.", e);
            return List.of();
        }
    }

    private static List<X509Certificate> tryLoadOsCerts(String rootStoreId) {
        try {
            return TrustStores.loadOsCerts(rootStoreId);
        }
        catch (Exception e) {
            log.warn("Failed to load OS trust store. Will ignore error and rely on Java certs.", e);
            return List.of();
        }
    }

    private static List<X509Certificate> loadOsCerts(String rootStoreId) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore osRootStore = TrustStores.loadOsTrustStore(rootStoreId);
        ArrayList<X509Certificate> osCerts = new ArrayList<X509Certificate>(osRootStore.size());
        for (String alias : Collections.list(osRootStore.aliases())) {
            osCerts.add((X509Certificate)osRootStore.getCertificate(alias));
        }
        log.debug("Loaded OS certificates: {}", (Object)UnsafeArg.of("certificates", osCerts.stream().map(cert -> cert.getSubjectX500Principal().getName()).collect(Collectors.toList())));
        return osCerts;
    }

    private static KeyStore loadOsTrustStore(String trustStoreId) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore rootStore = KeyStore.getInstance(trustStoreId);
        rootStore.load(null, null);
        return rootStore;
    }

    private static X509TrustManager createX509TrustManager(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        }
        catch (GeneralSecurityException e) {
            throw new SafeRuntimeException("Failed to create trust manager", (Throwable)e, new Arg[0]);
        }
    }

    private static SSLSocketFactory createSslSocketFactory(TrustManager trustManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            sslContext.init(new KeyManager[0], new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new SafeRuntimeException("Failed to create SslSocketFactory", (Throwable)e, new Arg[0]);
        }
    }

    private static Path createEmptyPemFile() {
        try {
            Path tempFile = Files.createTempFile("emptyFile", ".pem", new FileAttribute[0]);
            return tempFile;
        }
        catch (IOException e) {
            throw new SafeRuntimeException("Failed to load empty certificates path", (Throwable)e, new Arg[0]);
        }
    }

    private TrustStores() {
    }

    @VisibleForTesting
    static enum OsStoreId {
        WINDOWS("Windows-ROOT"),
        MAC("KeyChainStore"),
        INVALID_ID_FOR_TESTING("NotARealStore");

        private final String storeId;

        private OsStoreId(String storeId) {
            this.storeId = storeId;
        }
    }
}

