/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query;

import com.palantir.foundry.sql.query.ColumnAccessor;
import com.palantir.foundry.sql.query.DecodedTicketStream;
import com.palantir.foundry.sql.query.TicketStreamIterator;
import com.palantir.foundry.sql.query.converters.BigIntArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.BitArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.DateDayArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.DateMilliArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.DecimalArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.Float4ArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.Float8ArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.IntArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.LargeVarBinaryArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.LargeVarCharArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.ListArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.MapArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.SmallIntArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.StructArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TimeStampArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TinyIntArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.VarBinaryArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.VarCharArrowVectorConverter;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import shadow.palantir.driver.com.google.common.io.CountingInputStream;
import shadow.palantir.driver.com.palantir.contour.ipc.TableLatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowSchemaUtils;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.tracing.CloseableTracer;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.arrow.compression.CommonsCompressionFactory;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.VectorSchemaRoot;
import shadow.palantir.driver.org.apache.arrow.vector.complex.ListVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.MapVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.StructVector;
import shadow.palantir.driver.org.apache.arrow.vector.compression.CompressionCodec;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.ArrowStreamReader;

public final class ArrowTicketStream
implements DecodedTicketStream {
    private final QueryId queryId;
    private final ZoneId zoneId;
    @Nullable
    private CountingInputStream input;
    @Nullable
    private ArrowStreamReader reader;
    @Nullable
    private VectorSchemaRoot root;
    private final List<FoundryFieldSchema> columnTypes;

    public ArrowTicketStream(QueryId queryId, BufferAllocator allocator, InputStream is, ZoneId zoneId) throws IOException {
        this.queryId = queryId;
        this.zoneId = zoneId;
        this.input = new CountingInputStream(is);
        this.reader = new ArrowStreamReader(this.input, allocator, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
        this.root = this.reader.getVectorSchemaRoot();
        TableLatitudeResultMetadata metadata = ArrowSchemaUtils.toTableLatitudeResultMetadata(this.root.getSchema());
        this.columnTypes = metadata.getColumnTypes();
    }

    @Override
    public QueryId queryId() {
        return this.queryId;
    }

    @Override
    public List<FoundryFieldSchema> getSchema() {
        return this.columnTypes;
    }

    @Override
    public ArrowStreamIterator getIterator() {
        return new ArrowStreamIterator(this, this.zoneId);
    }

    @Override
    public void close() throws IOException {
        if (this.root != null) {
            this.root.clear();
            this.root = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.input = null;
        }
    }

    public static final class ArrowStreamIterator
    implements TicketStreamIterator {
        private final ArrowTicketStream ticketStream;
        private final ZoneId zoneId;
        private int currentRowInRecordBatch;
        private int rowCountInCurrentRecordBatch;
        private boolean eof = false;
        @Nullable
        private List<ColumnAccessor> currentConverters;

        ArrowStreamIterator(ArrowTicketStream ticketStream, ZoneId zoneId) {
            this.ticketStream = ticketStream;
            this.zoneId = zoneId;
            this.currentRowInRecordBatch = -1;
            this.rowCountInCurrentRecordBatch = 0;
        }

        @Override
        public boolean next() {
            boolean hasNext;
            Preconditions.checkState(this.ticketStream.input != null && this.ticketStream.reader != null && this.ticketStream.root != null, "Cannot call 'next' when stream has been closed");
            if (this.eof) {
                return false;
            }
            ++this.currentRowInRecordBatch;
            if (this.currentRowInRecordBatch < this.rowCountInCurrentRecordBatch) {
                return true;
            }
            try (CloseableTracer ignore = CloseableTracer.startSpan("foundry-sql-driver: load-arrow-batch");){
                hasNext = this.ticketStream.reader.loadNextBatch();
            }
            catch (IOException e) {
                throw new SafeRuntimeException("Unable to load Arrow batch", (Throwable)e, new Arg[0]);
            }
            if (hasNext) {
                this.currentRowInRecordBatch = 0;
                this.rowCountInCurrentRecordBatch = this.ticketStream.root.getRowCount();
                if (this.currentConverters == null) {
                    this.currentConverters = this.initConverters(this.ticketStream.root.getFieldVectors());
                }
                return true;
            }
            try {
                Preconditions.checkState(this.ticketStream.input.read() == 69, "Unexpected end of ARROW stream");
            }
            catch (IOException e) {
                throw new SafeRuntimeException("Unable to read end of stream", (Throwable)e, new Arg[0]);
            }
            this.eof = true;
            return false;
        }

        @Override
        public ColumnAccessor getColumnAccessor(int columnIndex) {
            Preconditions.checkNotNull(this.currentConverters, "Cannot call 'getColumnAccessor' before calling 'next'");
            if (columnIndex < 0 || columnIndex >= this.currentConverters.size()) {
                throw new SafeIllegalArgumentException("Invalid column index", SafeArg.of("index", columnIndex));
            }
            return this.currentConverters.get(columnIndex);
        }

        @Override
        public int getCurrentRow() {
            return this.currentRowInRecordBatch;
        }

        @Override
        public long getBytesRead() {
            return this.ticketStream.input == null ? 0L : this.ticketStream.input.getCount();
        }

        @Override
        public void close() throws IOException {
            this.ticketStream.close();
        }

        private List<ColumnAccessor> initConverters(List<? extends ValueVector> valueVectors) {
            ArrayList<ColumnAccessor> converters = new ArrayList<ColumnAccessor>(valueVectors.size());
            for (int index = 0; index < valueVectors.size(); ++index) {
                ValueVector vector = valueVectors.get(index);
                converters.add(this.getAccessor(vector, index));
            }
            return converters;
        }

        private ColumnAccessor getAccessor(ValueVector vector, int index) {
            switch (vector.getMinorType()) {
                case BIGINT: {
                    return new BigIntArrowVectorConverter(vector);
                }
                case BIT: {
                    return new BitArrowVectorConverter(vector);
                }
                case DATEDAY: {
                    return new DateDayArrowVectorConverter(vector);
                }
                case DATEMILLI: {
                    return new DateMilliArrowVectorConverter(vector);
                }
                case DECIMAL: {
                    return new DecimalArrowVectorConverter(vector);
                }
                case FLOAT4: {
                    return new Float4ArrowVectorConverter(vector);
                }
                case FLOAT8: {
                    return new Float8ArrowVectorConverter(vector);
                }
                case INT: {
                    return new IntArrowVectorConverter(vector);
                }
                case LARGEVARBINARY: {
                    return new LargeVarBinaryArrowVectorConverter(vector);
                }
                case LARGEVARCHAR: {
                    return new LargeVarCharArrowVectorConverter(vector);
                }
                case LIST: {
                    ListVector listVector = (ListVector)vector;
                    ColumnAccessor elementAccessor = this.getAccessor(listVector.getDataVector(), 0);
                    return new ListArrowVectorConverter(vector, elementAccessor);
                }
                case MAP: {
                    MapVector mapVector = (MapVector)vector;
                    StructVector mapDataVector = (StructVector)mapVector.getDataVector();
                    ColumnAccessor keysAccessor = this.getAccessor(mapDataVector.getChild("key"), 0);
                    ColumnAccessor valuesAccessor = this.getAccessor(mapDataVector.getChild("value"), 0);
                    return new MapArrowVectorConverter(mapVector, keysAccessor, valuesAccessor);
                }
                case SMALLINT: {
                    return new SmallIntArrowVectorConverter(vector);
                }
                case STRUCT: {
                    StructVector structVector = (StructVector)vector;
                    HashMap<String, ColumnAccessor> childrenAccessors = new HashMap<String, ColumnAccessor>();
                    for (String fieldName : structVector.getChildFieldNames()) {
                        childrenAccessors.put(fieldName, this.getAccessor(structVector.getChild(fieldName), 0));
                    }
                    return new StructArrowVectorConverter(vector, childrenAccessors);
                }
                case TIMESTAMPSEC: 
                case TIMESTAMPSECTZ: 
                case TIMESTAMPMILLI: 
                case TIMESTAMPMILLITZ: 
                case TIMESTAMPMICRO: 
                case TIMESTAMPMICROTZ: 
                case TIMESTAMPNANO: 
                case TIMESTAMPNANOTZ: {
                    return new TimeStampArrowVectorConverter(vector, this.zoneId);
                }
                case TINYINT: {
                    return new TinyIntArrowVectorConverter(vector);
                }
                case VARBINARY: {
                    return new VarBinaryArrowVectorConverter(vector);
                }
                case VARCHAR: {
                    return new VarCharArrowVectorConverter(vector);
                }
            }
            throw new SafeIllegalArgumentException("Unsupported Arrow type", SafeArg.of("type", vector.getMinorType()), SafeArg.of("columIndex", index));
        }
    }
}

