/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.query.ColumnAccessor;
import com.palantir.foundry.sql.query.DecodedTicketStream;
import com.palantir.foundry.sql.query.ResultIterator;
import com.palantir.foundry.sql.query.TicketDecoder;
import com.palantir.foundry.sql.query.TicketDownloader;
import com.palantir.foundry.sql.query.TicketStreamIterator;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Throwables;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class DefaultResultIterator
implements ResultIterator {
    private static final Logger log = DriverLoggerFactory.getLogger(DefaultResultIterator.class);
    private static final Duration SLEEP_DURATION = Duration.ofSeconds(2L);
    private final TicketDownloader ticketDownloader;
    private final TicketDecoder ticketDecoder;
    private final boolean retryStreamsOnError;
    private long bytesRead = 0L;
    private long nextRowIndexInCurrentTicketStream = 0L;
    @Nullable
    private QueryId queryId;
    @Nullable
    private List<FoundryFieldSchema> schema;
    @Nullable
    private TicketStreamIterator ticketIterator;

    DefaultResultIterator(TicketDownloader ticketDownloader, TicketDecoder ticketDecoder, boolean retryStreamsOnError) {
        this.ticketDownloader = ticketDownloader;
        this.ticketDecoder = ticketDecoder;
        this.retryStreamsOnError = retryStreamsOnError;
        Preconditions.checkState(ticketDownloader.next(), "No ticket streams");
        try {
            this.loadCurrentTicketAtStart();
        }
        catch (Exception e) {
            try {
                log.warn("Caught error initializing results. Retrying...", e);
                this.sleep();
                this.loadCurrentTicketAtStart();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
                throw e;
            }
        }
    }

    @Override
    public QueryId queryId() {
        return Preconditions.checkNotNull(this.queryId);
    }

    @Override
    public List<FoundryFieldSchema> schema() {
        return Preconditions.checkNotNull(this.schema);
    }

    @Override
    public boolean next() {
        boolean hasNext = this.nextWithRetry();
        ++this.nextRowIndexInCurrentTicketStream;
        return hasNext;
    }

    @Override
    public ColumnAccessor getColumnAccessor(int columnIndex) {
        Preconditions.checkState(this.ticketIterator != null, "Cannot call 'getColumnAccessor' before calling 'next'");
        return this.ticketIterator.getColumnAccessor(columnIndex);
    }

    @Override
    public int getCurrentColumnAccessorIndex() {
        Preconditions.checkState(this.ticketIterator != null, "Cannot call 'getCurrentColumnAccessorIndex' before calling 'next'");
        return this.ticketIterator.getCurrentRow();
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead + (this.ticketIterator == null ? 0L : this.ticketIterator.getBytesRead());
    }

    @Override
    public void close() {
        this.ticketDownloader.close();
        this.closeCurrentIterator();
    }

    @VisibleForTesting
    boolean retryStreamsOnError() {
        return this.retryStreamsOnError;
    }

    private boolean nextWithRetry() {
        try {
            return this.nextImpl();
        }
        catch (Exception e) {
            if (this.retryStreamsOnError) {
                try {
                    log.warn("Caught error loading results. Retrying...", e);
                    this.sleep();
                    this.loadCurrentTicketAtRow(this.nextRowIndexInCurrentTicketStream);
                    return this.nextImpl();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                    throw e;
                }
            }
            throw e;
        }
    }

    private boolean nextImpl() {
        if (Preconditions.checkNotNull(this.ticketIterator).next()) {
            return true;
        }
        while (this.ticketDownloader.next()) {
            this.loadCurrentTicketAtStart();
            if (!this.ticketIterator.next()) continue;
            return true;
        }
        this.closeCurrentIterator();
        return false;
    }

    private void loadCurrentTicketAtStart() {
        this.loadCurrentTicketAtRow(0L);
    }

    private void loadCurrentTicketAtRow(long row) {
        this.closeCurrentIterator();
        TicketDownloader.Stream stream = this.ticketDownloader.loadCurrent(SafeLong.of(row));
        DecodedTicketStream decodedStream = this.decodeTicketStream(stream);
        if (this.schema == null) {
            this.schema = decodedStream.getSchema();
        } else {
            Preconditions.checkState(decodedStream.getSchema().equals(this.schema), "Ticket had incorrect schema");
        }
        this.queryId = decodedStream.queryId();
        this.ticketIterator = decodedStream.getIterator();
        this.nextRowIndexInCurrentTicketStream = row;
    }

    private DecodedTicketStream decodeTicketStream(TicketDownloader.Stream stream) {
        try {
            return this.ticketDecoder.decode(stream.ticket(), stream.stream());
        }
        catch (IOException e) {
            throw new SafeRuntimeException("Unable to decode stream", (Throwable)e, new Arg[0]);
        }
    }

    private void closeCurrentIterator() {
        if (this.ticketIterator == null) {
            return;
        }
        try {
            long bytes = this.ticketIterator.getBytesRead();
            this.ticketIterator.close();
            this.ticketIterator = null;
            this.bytesRead += bytes;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new SafeRuntimeException("Unable to close ticket iterator", (Throwable)e, new Arg[0]);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(SLEEP_DURATION.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

