/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query;

import com.palantir.foundry.sql.driver.logging.DriverLoggerFactory;
import com.palantir.foundry.sql.query.DefaultResultIterator;
import com.palantir.foundry.sql.query.ResultIterator;
import com.palantir.foundry.sql.query.TicketDecoder;
import com.palantir.foundry.sql.query.TicketDownloader;
import com.palantir.foundry.sql.query.UncheckedSqlException;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shadow.palantir.driver.com.google.common.base.Stopwatch;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CanceledQueryStatus;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.FailedQueryStatus;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryIdV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryStatusV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ReadyQueryStatusV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.RunningQueryStatusV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SerializationProtocol;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlExecuteRequestV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlExecuteResponseV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQuery;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQueryServiceV2Blocking;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;

public final class FoundrySqlClient {
    private static final Logger log = DriverLoggerFactory.getLogger(DefaultResultIterator.class);
    private final Supplier<AuthHeader> authHeader;
    private final SqlQueryServiceV2Blocking client;
    private final Executor bufferExecutor;
    private final boolean compressArrow;
    private final Optional<Integer> numTicketStreamsToBuffer;
    private final Optional<Integer> maxStreamSizeToBuffer;
    private final boolean retryStreamsOnError;
    private final TicketDecoder ticketDecoder;
    private final SerializationProtocol serializationProtocol;
    private final SqlDialect dialect;
    private final List<Branch> fallbackBranchIds;

    public FoundrySqlClient(Supplier<AuthHeader> authHeader, SqlQueryServiceV2Blocking client, Executor bufferExecutor, BufferAllocator allocator, boolean compressArrow, Optional<Integer> numTicketStreamsToBuffer, Optional<Integer> maxStreamSizeToBuffer, boolean retryStreamsOnError, SerializationProtocol serializationProtocol, SqlDialect dialect, List<Branch> fallbackBranchIds, ZoneId zoneId) {
        this.authHeader = authHeader;
        this.client = client;
        this.bufferExecutor = bufferExecutor;
        this.compressArrow = compressArrow;
        this.numTicketStreamsToBuffer = numTicketStreamsToBuffer;
        this.maxStreamSizeToBuffer = maxStreamSizeToBuffer;
        this.retryStreamsOnError = retryStreamsOnError;
        this.ticketDecoder = new TicketDecoder(allocator, zoneId);
        this.serializationProtocol = serializationProtocol;
        this.dialect = dialect;
        this.fallbackBranchIds = fallbackBranchIds;
    }

    @MustBeClosed
    public ResultIterator execute(SqlQuery query, Optional<Parameters> parameters) throws SQLException {
        log.info("Executing query: {}. Parameters: {}", (Object)UnsafeArg.of("query", query), (Object)UnsafeArg.of("parameters", parameters));
        Stopwatch stopwatch = Stopwatch.createStarted();
        SqlExecuteResponseV2 response = this.client.execute(this.authHeader.get(), SqlExecuteRequestV2.builder().query(query).dialect(this.dialect).serializationProtocol(this.serializationProtocol).parameters(parameters).fallbackBranchIds(this.fallbackBranchIds).build());
        log.info("Query executed. Duration: {}", (Object)SafeArg.of("duration", stopwatch.stop()));
        QueryStatusV2 initialStatus = response.getStatus();
        Optional<ReadyQueryStatusV2> maybeReadyStatus = this.getReady(initialStatus);
        stopwatch.reset();
        stopwatch.start();
        while (maybeReadyStatus.isEmpty()) {
            maybeReadyStatus = this.getReady(this.client.getStatus(this.authHeader.get(), initialStatus.accept(GetQueryId.INSTANCE)).getStatus());
        }
        log.info("Query results ready. Duration: {}", (Object)SafeArg.of("duration", stopwatch.stop()));
        ReadyQueryStatusV2 readyStatus = maybeReadyStatus.orElseThrow();
        boolean canRetry = this.retryStreamsOnError && readyStatus.getDeterministic();
        TicketDownloader ticketDownloader = new TicketDownloader(this.authHeader, this.client, this.bufferExecutor, readyStatus.getTickets(), this.compressArrow, this.numTicketStreamsToBuffer, this.maxStreamSizeToBuffer);
        return new DefaultResultIterator(ticketDownloader, this.ticketDecoder, canRetry);
    }

    private Optional<ReadyQueryStatusV2> getReady(QueryStatusV2 status) throws SQLException {
        try {
            return status.accept(GetReadyStatus.INSTANCE);
        }
        catch (UncheckedSqlException e) {
            log.error("Query failed", e);
            throw e.toSqlException();
        }
    }

    private static enum GetQueryId implements QueryStatusV2.Visitor<QueryIdV2>
    {
        INSTANCE;


        @Override
        public QueryIdV2 visitCanceled(CanceledQueryStatus _status) {
            throw new UncheckedSqlException("Executing query failed. Query was already cancelled");
        }

        @Override
        public QueryIdV2 visitFailed(FailedQueryStatus status) {
            String message = String.format("Executing query failed. %s - %s", status.getFailureReason(), status.getErrorMessage().orElse(""));
            throw new UncheckedSqlException(message);
        }

        @Override
        public QueryIdV2 visitReady(ReadyQueryStatusV2 _status) {
            throw new SafeIllegalStateException("Query is ready", new Arg[0]);
        }

        @Override
        public QueryIdV2 visitRunning(RunningQueryStatusV2 status) {
            return status.getQueryId();
        }

        @Override
        public QueryIdV2 visitUnknown(String _unknownType) {
            throw new UncheckedSqlException("Executing query failed. Query was in unknown state");
        }
    }

    private static enum GetReadyStatus implements QueryStatusV2.Visitor<Optional<ReadyQueryStatusV2>>
    {
        INSTANCE;


        @Override
        public Optional<ReadyQueryStatusV2> visitCanceled(CanceledQueryStatus _status) {
            throw new UncheckedSqlException("Executing query failed. Query was already cancelled");
        }

        @Override
        public Optional<ReadyQueryStatusV2> visitFailed(FailedQueryStatus status) {
            String message = String.format("Executing query failed. %s - %s", status.getFailureReason(), status.getErrorMessage().orElse(""));
            throw new UncheckedSqlException(message);
        }

        @Override
        public Optional<ReadyQueryStatusV2> visitReady(ReadyQueryStatusV2 status) {
            return Optional.of(status);
        }

        @Override
        public Optional<ReadyQueryStatusV2> visitRunning(RunningQueryStatusV2 _status) {
            return Optional.empty();
        }

        @Override
        public Optional<ReadyQueryStatusV2> visitUnknown(String _status) {
            throw new UncheckedSqlException("Executing query failed. Query was in unknown state");
        }
    }
}

