/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query;

import com.palantir.foundry.sql.query.TicketDownloader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Ticket;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TicketDownloader.Stream", generator="Immutables")
@Immutable
final class ImmutableStream
implements TicketDownloader.Stream {
    private final Ticket ticket;
    private final InputStream stream;

    private ImmutableStream(Ticket ticket, InputStream stream) {
        this.ticket = Objects.requireNonNull(ticket, "ticket");
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    private ImmutableStream(ImmutableStream original, Ticket ticket, InputStream stream) {
        this.ticket = ticket;
        this.stream = stream;
    }

    @Override
    public Ticket ticket() {
        return this.ticket;
    }

    @Override
    public InputStream stream() {
        return this.stream;
    }

    public final ImmutableStream withTicket(Ticket value) {
        if (this.ticket == value) {
            return this;
        }
        Ticket newValue = Objects.requireNonNull(value, "ticket");
        return new ImmutableStream(this, newValue, this.stream);
    }

    public final ImmutableStream withStream(InputStream value) {
        if (this.stream == value) {
            return this;
        }
        InputStream newValue = Objects.requireNonNull(value, "stream");
        return new ImmutableStream(this, this.ticket, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStream && this.equalsByValue((ImmutableStream)another);
    }

    private boolean equalsByValue(ImmutableStream another) {
        return this.ticket.equals(another.ticket) && this.stream.equals(another.stream);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ticket.hashCode();
        h += (h << 5) + this.stream.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Stream").omitNullValues().add("ticket", this.ticket).add("stream", this.stream).toString();
    }

    public static ImmutableStream of(Ticket ticket, InputStream stream) {
        return new ImmutableStream(ticket, stream);
    }

    public static ImmutableStream copyOf(TicketDownloader.Stream instance) {
        if (instance instanceof ImmutableStream) {
            return (ImmutableStream)instance;
        }
        return ImmutableStream.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TicketDownloader.Stream", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TICKET = 1L;
        private static final long INIT_BIT_STREAM = 2L;
        private long initBits = 3L;
        @Nullable
        private Ticket ticket;
        @Nullable
        private InputStream stream;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TicketDownloader.Stream instance) {
            Objects.requireNonNull(instance, "instance");
            this.ticket(instance.ticket());
            this.stream(instance.stream());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ticket(Ticket ticket) {
            this.ticket = Objects.requireNonNull(ticket, "ticket");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stream(InputStream stream) {
            this.stream = Objects.requireNonNull(stream, "stream");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStream build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStream(null, this.ticket, this.stream);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ticket");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stream");
            }
            return "Cannot build Stream, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

