/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query;

import com.palantir.foundry.sql.query.ArrowTicketStream;
import com.palantir.foundry.sql.query.DecodedTicketStream;
import com.palantir.foundry.sql.query.ImmutableTicketContent;
import com.palantir.logsafe.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.palantir.driver.com.auth0.jwt.JWT;
import shadow.palantir.driver.com.auth0.jwt.interfaces.DecodedJWT;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ObjectMappers;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Ticket;
import shadow.palantir.driver.com.palantir.tracing.CloseableTracer;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;
import shadow.palantir.driver.org.apache.commons.io.IOUtils;
import shadow.palantir.driver.org.immutables.value.Value;

public final class TicketDecoder {
    private static final Logger log = LoggerFactory.getLogger(TicketDecoder.class);
    private static final ObjectMapper mapper = ObjectMappers.newSmileClientObjectMapper();
    private static final QueryId UNKNOWN_QUERY_ID = QueryId.of("unknown");
    private static final String V1_CLAIM = "v1";
    private final BufferAllocator allocator;
    private final ZoneId zoneId;

    public TicketDecoder(BufferAllocator allocator, ZoneId zoneId) {
        this.allocator = allocator;
        this.zoneId = zoneId;
    }

    public DecodedTicketStream decode(Ticket ticket, InputStream is) throws IOException {
        CloseableTracer ignore = CloseableTracer.startSpan("foundry-sql-driver: load-stream");
        try {
            Preconditions.checkState(is.read() == 65, "Expected arrow stream");
            ArrowTicketStream arrowTicketStream = new ArrowTicketStream(TicketDecoder.getQueryId(ticket), this.allocator, is, this.zoneId);
            if (ignore != null) {
                ignore.close();
            }
            return arrowTicketStream;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                IOUtils.closeQuietly((Closeable)is, e::addSuppressed);
                throw e;
            }
        }
    }

    private static QueryId getQueryId(Ticket ticket) {
        try {
            DecodedJWT jwt = JWT.decode(ticket.get());
            String claim = jwt.getClaim(V1_CLAIM).asString();
            if (claim == null) {
                return UNKNOWN_QUERY_ID;
            }
            TicketContent content = mapper.readValue(Base64.getDecoder().decode(claim), TicketContent.class);
            return content.queryId();
        }
        catch (Exception e) {
            log.warn("Unable to decode ticket", e);
            return UNKNOWN_QUERY_ID;
        }
    }

    @JsonDeserialize(as=ImmutableTicketContent.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Value.Immutable
    static interface TicketContent {
        public QueryId queryId();
    }
}

