/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import java.math.BigDecimal;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.arrow.vector.BitVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;

public final class BitArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final BitVector bitVector;

    public BitArrowVectorConverter(ValueVector valueVector) {
        super(valueVector);
        this.bitVector = (BitVector)valueVector;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.bitVector.get(index) == 1;
    }

    @Override
    public byte getByte(int index) {
        return this.getBoolean(index) ? (byte)1 : 0;
    }

    @Override
    public BigDecimal getDecimal(int index) {
        return this.getBoolean(index) ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public double getDouble(int index) {
        return this.getBoolean(index) ? 1.0 : 0.0;
    }

    @Override
    public float getFloat(int index) {
        return this.getBoolean(index) ? 1.0f : 0.0f;
    }

    @Override
    public int getInteger(int index) {
        return this.getBoolean(index) ? 1 : 0;
    }

    @Override
    public long getLong(int index) {
        return this.getBoolean(index) ? 1L : 0L;
    }

    @Override
    public short getShort(int index) {
        return this.getBoolean(index) ? (short)1 : 0;
    }

    @Override
    @Nullable
    public Object getObject(int index) {
        return this.bitVector.getObject(index);
    }

    @Override
    public String getString(int index) {
        return TypeConversions.toString(this.getBoolean(index));
    }
}

