/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.ColumnAccessor;
import com.palantir.logsafe.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shadow.palantir.driver.com.google.common.collect.Maps;
import shadow.palantir.driver.org.apache.arrow.vector.complex.MapVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.StructVector;

final class ComplexTypeUtils {
    static List<Object> toArray(ColumnAccessor accessor, int offset, int length) {
        ArrayList<Object> array = new ArrayList<Object>(length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (accessor.isNull(i)) {
                array.add(null);
                continue;
            }
            array.add(accessor.getRawObject(i));
        }
        return array;
    }

    static Map<Object, Object> toMap(MapVector mapVector, ColumnAccessor keysAccessor, ColumnAccessor valuesAccessor, int index) {
        int offset = mapVector.getOffsetBuffer().getInt((long)index * 4L);
        int length = mapVector.getInnerValueCountAt(index);
        List<Object> keys = ComplexTypeUtils.toArray(keysAccessor, offset, length);
        List<Object> values = ComplexTypeUtils.toArray(valuesAccessor, offset, length);
        HashMap<Object, Object> map = Maps.newHashMapWithExpectedSize(length);
        for (int pos = 0; pos < length; ++pos) {
            map.put(keys.get(pos), values.get(pos));
        }
        return map;
    }

    static Map<String, Object> toStruct(StructVector structVector, Map<String, ColumnAccessor> childrenAccessors, int index) {
        LinkedHashMap<String, Object> struct = Maps.newLinkedHashMapWithExpectedSize(structVector.getChildFieldNames().size());
        for (String fieldName : structVector.getChildFieldNames()) {
            ColumnAccessor accessor = Preconditions.checkNotNull(childrenAccessors.get(fieldName));
            if (accessor.isNull(index)) {
                struct.put(fieldName, null);
                continue;
            }
            Object value = accessor.getRawObject(index);
            struct.put(fieldName, value);
        }
        return struct;
    }

    private ComplexTypeUtils() {
    }
}

