/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import com.palantir.logsafe.Preconditions;
import java.time.LocalDate;
import shadow.palantir.driver.org.apache.arrow.vector.DateDayVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;

public final class DateDayArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final DateDayVector dateDayVector;

    public DateDayArrowVectorConverter(ValueVector valueVector) {
        super(valueVector);
        this.dateDayVector = (DateDayVector)valueVector;
    }

    @Override
    public LocalDate getDate(int index) {
        Preconditions.checkState(!this.isNull(index), "Unexpected null");
        return LocalDate.ofEpochDay(this.dateDayVector.get(index));
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index);
    }

    @Override
    public String getString(int index) {
        return TypeConversions.toString(this.getDate(index));
    }
}

