/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import com.palantir.logsafe.Preconditions;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import shadow.palantir.driver.org.apache.arrow.vector.DateMilliVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;

public final class DateMilliArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final DateMilliVector dateMilliVector;

    public DateMilliArrowVectorConverter(ValueVector valueVector) {
        super(valueVector);
        this.dateMilliVector = (DateMilliVector)valueVector;
    }

    @Override
    public LocalDate getDate(int index) {
        Preconditions.checkState(!this.isNull(index), "Unexpected null");
        return LocalDate.ofInstant(Instant.ofEpochMilli(this.dateMilliVector.get(index)), ZoneOffset.UTC);
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index);
    }

    @Override
    public String getString(int index) {
        return TypeConversions.toString(this.getDate(index));
    }
}

