/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import java.math.BigDecimal;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.arrow.vector.DecimalVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;

public final class DecimalArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final DecimalVector decimalVector;

    public DecimalArrowVectorConverter(ValueVector valueVector) {
        super(valueVector);
        this.decimalVector = (DecimalVector)valueVector;
    }

    @Override
    public BigDecimal getDecimal(int index) {
        return this.decimalVector.getObject(index);
    }

    @Override
    public byte getByte(int index) {
        return this.getDecimal(index).byteValueExact();
    }

    @Override
    public double getDouble(int index) {
        return this.getDecimal(index).doubleValue();
    }

    @Override
    public float getFloat(int index) {
        return this.getDecimal(index).floatValue();
    }

    @Override
    public int getInteger(int index) {
        return this.getDecimal(index).intValueExact();
    }

    @Override
    public long getLong(int index) {
        return this.getDecimal(index).longValueExact();
    }

    @Override
    public short getShort(int index) {
        return this.getDecimal(index).shortValueExact();
    }

    @Override
    @Nullable
    public Object getObject(int index) {
        return this.decimalVector.getObject(index);
    }

    @Override
    public String getString(int index) {
        return TypeConversions.toString(this.getDecimal(index));
    }
}

