/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.ColumnAccessor;
import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.ComplexTypeUtils;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import com.palantir.logsafe.Preconditions;
import java.util.List;
import shadow.palantir.driver.org.apache.arrow.memory.ArrowBuf;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.ListVector;

public final class ListArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final ListVector listVector;
    private final ColumnAccessor elementAccessor;

    public ListArrowVectorConverter(ValueVector valueVector, ColumnAccessor elementAccessor) {
        super(valueVector);
        this.listVector = (ListVector)valueVector;
        this.elementAccessor = elementAccessor;
    }

    @Override
    public String getArray(int index) {
        return TypeConversions.toString(this.getRawArray(index));
    }

    @Override
    public Object getObject(int index) {
        return this.getArray(index);
    }

    @Override
    public List<?> getRawObject(int index) {
        return this.getRawArray(index);
    }

    @Override
    public String getString(int index) {
        return this.getArray(index);
    }

    private List<?> getRawArray(int index) {
        Preconditions.checkState(!this.isNull(index), "Unexpected null");
        ArrowBuf offsets = this.listVector.getOffsetBuffer();
        int start = offsets.getInt(index * 4);
        int end = offsets.getInt((index + 1) * 4);
        int length = end - start;
        return ComplexTypeUtils.toArray(this.elementAccessor, start, length);
    }
}

