/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.ColumnAccessor;
import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.ComplexTypeUtils;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import com.palantir.logsafe.Preconditions;
import java.util.Map;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.MapVector;

public final class MapArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final MapVector mapVector;
    private final ColumnAccessor keysAccessor;
    private final ColumnAccessor valuesAccessor;

    public MapArrowVectorConverter(ValueVector valueVector, ColumnAccessor keysAccessor, ColumnAccessor valuesAccessor) {
        super(valueVector);
        this.mapVector = (MapVector)valueVector;
        this.keysAccessor = keysAccessor;
        this.valuesAccessor = valuesAccessor;
    }

    @Override
    public String getMap(int index) {
        return TypeConversions.toString(this.getRawMap(index));
    }

    @Override
    public Object getObject(int index) {
        return this.getMap(index);
    }

    @Override
    public Map<Object, Object> getRawObject(int index) {
        return this.getRawMap(index);
    }

    @Override
    public String getString(int index) {
        return this.getMap(index);
    }

    private Map<Object, Object> getRawMap(int index) {
        Preconditions.checkState(!this.isNull(index), "Unexpected null");
        return ComplexTypeUtils.toMap(this.mapVector, this.keysAccessor, this.valuesAccessor, index);
    }
}

