/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.ColumnAccessor;
import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.ComplexTypeUtils;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import com.palantir.logsafe.Preconditions;
import java.util.Map;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.StructVector;

public final class StructArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final StructVector structVector;
    private final Map<String, ColumnAccessor> childrenAccessors;

    public StructArrowVectorConverter(ValueVector valueVector, Map<String, ColumnAccessor> childrenAccessors) {
        super(valueVector);
        this.structVector = (StructVector)valueVector;
        this.childrenAccessors = childrenAccessors;
    }

    @Override
    public String getStruct(int index) {
        return TypeConversions.toString(this.getRawStruct(index));
    }

    @Override
    public Object getObject(int index) {
        return this.getStruct(index);
    }

    @Override
    public Map<String, ?> getRawObject(int index) {
        return this.getRawStruct(index);
    }

    @Override
    public String getString(int index) {
        return this.getStruct(index);
    }

    private Map<String, ?> getRawStruct(int index) {
        Preconditions.checkState(!this.isNull(index), "Unexpected null");
        return ComplexTypeUtils.toStruct(this.structVector, this.childrenAccessors, index);
    }
}

