/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import com.palantir.foundry.sql.query.converters.TypeConversions;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.arrow.vector.TimeStampVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;

public final class TimeStampArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final TimeStampVector timeStampVector;
    private final ZoneId zoneId;

    public TimeStampArrowVectorConverter(ValueVector valueVector, ZoneId zoneId) {
        super(valueVector);
        this.timeStampVector = (TimeStampVector)valueVector;
        this.zoneId = zoneId;
    }

    @Override
    public Instant getInstant(int index) {
        Preconditions.checkState(!this.isNull(index), "Unexpected null");
        long value = this.timeStampVector.get(index);
        switch (this.timeStampVector.getMinorType()) {
            case TIMESTAMPSEC: 
            case TIMESTAMPSECTZ: {
                return Instant.ofEpochSecond(value);
            }
            case TIMESTAMPMILLI: 
            case TIMESTAMPMILLITZ: {
                return Instant.ofEpochMilli(value);
            }
            case TIMESTAMPMICRO: 
            case TIMESTAMPMICROTZ: {
                long microsSeconds = TimeUnit.MICROSECONDS.toSeconds(value);
                long microsAdjustment = TimeUnit.MICROSECONDS.toNanos(value - TimeUnit.SECONDS.toMicros(microsSeconds));
                return Instant.ofEpochSecond(microsSeconds, microsAdjustment);
            }
            case TIMESTAMPNANO: 
            case TIMESTAMPNANOTZ: {
                long nanosSeconds = TimeUnit.NANOSECONDS.toSeconds(value);
                long nanosAdjustment = value - TimeUnit.SECONDS.toNanos(nanosSeconds);
                return Instant.ofEpochSecond(nanosSeconds, nanosAdjustment);
            }
        }
        throw new SafeIllegalStateException("Unsupported timestamp vector type", SafeArg.of("type", this.timeStampVector.getMinorType()));
    }

    @Override
    public ZonedDateTime getZonedDateTime(int index) {
        return this.getInstant(index).atZone(this.zoneId);
    }

    @Override
    @Nullable
    public Object getObject(int index) {
        return this.getInstant(index);
    }

    @Override
    public String getString(int index) {
        return TypeConversions.toString(this.getZonedDateTime(index));
    }
}

