/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.google.common.io.BaseEncoding;
import shadow.palantir.driver.com.palantir.contour.ipc.ContourIpcJackson;

public final class TypeConversions {
    private static final ObjectMapper mapper = ContourIpcJackson.OBJECT_MAPPER;
    private static final BaseEncoding HEX_ENCODING = BaseEncoding.base16();
    private static final DateTimeFormatter SQL_DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final int TIMESTAMP_FRACTIONAL_SCALE = 6;
    private static final DateTimeFormatter SQL_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss." + "S".repeat(6), Locale.ROOT);

    public static String toString(BigDecimal value) {
        return value.toPlainString();
    }

    public static String toString(boolean value) {
        return String.valueOf(value);
    }

    public static String toString(byte[] value) {
        return "0x" + HEX_ENCODING.encode(value);
    }

    public static String toString(byte value) {
        return String.valueOf(value);
    }

    public static String toString(LocalDate value) {
        return SQL_DATE_FORMAT.format(value);
    }

    public static String toString(double value) {
        return String.valueOf(value);
    }

    public static String toString(float value) {
        return String.valueOf(value);
    }

    public static String toString(int value) {
        return String.valueOf(value);
    }

    public static String toString(long value) {
        return String.valueOf(value);
    }

    public static String toString(short value) {
        return String.valueOf(value);
    }

    public static String toString(Instant value, ZoneId zoneId) {
        return SQL_TIMESTAMP_FORMAT.format(value.atZone(zoneId));
    }

    public static String toString(ZonedDateTime zonedDateTime) {
        return SQL_TIMESTAMP_FORMAT.format(zonedDateTime);
    }

    public static String toString(List<?> value) {
        return TypeConversions.complexObjectToString(value);
    }

    public static String toString(Map<?, ?> value) {
        return TypeConversions.complexObjectToString(value);
    }

    private static String complexObjectToString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new SafeRuntimeException("Failed to parse complex type", (Throwable)e, new Arg[0]);
        }
    }

    private TypeConversions() {
    }
}

