/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.query.converters;

import com.palantir.foundry.sql.query.converters.AbstractArrowVectorConverter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.VarCharVector;

public final class VarCharArrowVectorConverter
extends AbstractArrowVectorConverter {
    private final VarCharVector varCharVector;

    public VarCharArrowVectorConverter(ValueVector valueVector) {
        super(valueVector);
        this.varCharVector = (VarCharVector)valueVector;
    }

    @Override
    public LocalDate getDate(int index) {
        String stringVal = this.getString(index);
        return LocalDate.parse(stringVal, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    @Nullable
    public Object getObject(int index) {
        return this.getString(index);
    }

    @Override
    public String getString(int index) {
        return this.varCharVector.getObject(index).toString();
    }
}

