/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.foundry.sql.windows.crypto;

import com.palantir.foundry.sql.windows.crypto.WinDecryptor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.io.BaseEncoding;

public final class WinCrypto {
    private static final String ENCRYPTION_PREFIX = "enc:1:";
    private static final String MACHINE_ENCRYPTION_PREFIX = "enc:1:M:";
    private static final BaseEncoding HEX_ENCODING = BaseEncoding.base16();
    @VisibleForTesting
    static final Charset WINDOWS_CHARSET = StandardCharsets.UTF_16LE;

    public static String maybeDecrypt(String value, byte[] entropy) {
        return WinCrypto.maybeDecrypt(WinDecryptor.INSTANCE, value, entropy);
    }

    @VisibleForTesting
    static String maybeDecrypt(WinDecryptor decryptor, String value, byte[] entropy) {
        if (!value.startsWith(ENCRYPTION_PREFIX)) {
            return value;
        }
        int flags = 1;
        String valueWithoutPrefix = value.substring(MACHINE_ENCRYPTION_PREFIX.length());
        byte[] decrypted = decryptor.decrypt(WinCrypto.toBytes(valueWithoutPrefix), entropy, flags);
        return new String(decrypted, WINDOWS_CHARSET);
    }

    private static byte[] toBytes(String value) {
        return HEX_ENCODING.decode(value);
    }

    private WinCrypto() {
    }
}

