/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe;

import java.io.Serializable;
import java.util.Objects;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public abstract class Arg<T>
implements Serializable {
    @Nonnull
    private final String name;
    @Nullable
    private final T value;

    protected Arg(String name, @Nullable T value) {
        this.name = Objects.requireNonNull(name, "name may not be null");
        this.value = value;
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final T getValue() {
        return this.value;
    }

    public abstract boolean isSafeForLogging();

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Arg)) {
            return false;
        }
        Arg arg = (Arg)other;
        return Objects.equals(this.name, arg.name) && Objects.equals(this.value, arg.value) && this.isSafeForLogging() == arg.isSafeForLogging();
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Boolean.hashCode(this.isSafeForLogging());
        return result;
    }
}

