/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeNullPointerException;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.jetbrains.annotations.Contract;

public final class Preconditions {
    private Preconditions() {
    }

    @Contract(value="false -> fail")
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new SafeIllegalArgumentException();
        }
    }

    @Contract(value="false, _ -> fail")
    public static void checkArgument(boolean expression, @CompileTimeConstant String message) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, new Arg[0]);
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> arg) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg);
        }
    }

    @Contract(value="false, _, _, _ -> fail")
    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg1, arg2);
        }
    }

    @Contract(value="false, _, _, _, _ -> fail")
    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg1, arg2, arg3);
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> ... args) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, args);
        }
    }

    @Nonnull
    @CanIgnoreReturnValue
    @Contract(value="null -> fail; !null -> param1")
    public static <T> T checkArgumentNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new SafeIllegalArgumentException();
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    @Contract(value="null, _ -> fail; !null, _ -> param1")
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, new Arg[0]);
        }
        return reference;
    }

    @Nonnull
    @Contract(value="null, _, _ -> fail; !null, _, _ -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, arg);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    @Contract(value="null, _, _, _ -> fail; !null, _, _, _ -> param1")
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, arg1, arg2);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    @Contract(value="null, _, _, _, _ -> fail; !null, _, _, _, _ -> param1")
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, arg1, arg2, arg3);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    @Contract(value="null, _, _ -> fail; !null, _, _ -> param1")
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> ... args) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, args);
        }
        return reference;
    }

    @Contract(value="false -> fail")
    public static void checkState(boolean expression) {
        if (!expression) {
            throw new SafeIllegalStateException();
        }
    }

    @Contract(value="false, _ -> fail")
    public static void checkState(boolean expression, @CompileTimeConstant String message) {
        if (!expression) {
            throw new SafeIllegalStateException(message, new Arg[0]);
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> arg) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg);
        }
    }

    @Contract(value="false, _, _, _ -> fail")
    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg1, arg2);
        }
    }

    @Contract(value="false, _, _, _, _ -> fail")
    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg1, arg2, arg3);
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> ... args) {
        if (!expression) {
            throw new SafeIllegalStateException(message, args);
        }
    }

    @Nonnull
    @Contract(value="null -> fail; !null -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new SafeNullPointerException();
        }
        return reference;
    }

    @Nonnull
    @Contract(value="null, _ -> fail; !null, _ -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message) {
        if (reference == null) {
            throw new SafeNullPointerException(message, new Arg[0]);
        }
        return reference;
    }

    @Nonnull
    @Contract(value="null, _, _ -> fail; !null, _, _ -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg);
        }
        return reference;
    }

    @Nonnull
    @Contract(value="null, _, _, _ -> fail; !null, _, _, _ -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg1, arg2);
        }
        return reference;
    }

    @Nonnull
    @Contract(value="null, _, _, _, _ -> fail; !null, _, _, _, _ -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg1, arg2, arg3);
        }
        return reference;
    }

    @Nonnull
    @Contract(value="null, _, _ -> fail; !null, _, _ -> param1")
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> ... args) {
        if (reference == null) {
            throw new SafeNullPointerException(message, args);
        }
        return reference;
    }
}

