/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe.exceptions;

import com.palantir.logsafe.Arg;
import java.util.Arrays;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;

public final class SafeExceptions {
    private SafeExceptions() {
    }

    public static String renderMessage(@CompileTimeConstant String safeMessage, Arg<?> ... args) {
        if (args == null || args.length == 0) {
            return safeMessage;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(safeMessage).append(": {");
        boolean first = true;
        for (Arg<?> arg : args) {
            if (arg == null) continue;
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(arg.getName()).append("=");
            SafeExceptions.appendValue(builder, arg);
        }
        builder.append('}');
        return builder.toString();
    }

    private static void appendValue(StringBuilder builder, Arg<?> arg) {
        Object value = arg.getValue();
        if (value != null && value.getClass().isArray()) {
            String arrayString = Arrays.deepToString(new Object[]{value});
            builder.append(arrayString, 1, arrayString.length() - 1);
        } else {
            builder.append(value);
        }
    }
}

