/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe.exceptions;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.exceptions.SafeExceptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class SafeIoException
extends IOException
implements SafeLoggable {
    private final String logMessage;
    private final List<Arg<?>> arguments;

    public SafeIoException(@CompileTimeConstant String message, Arg<?> ... arguments) {
        super(SafeExceptions.renderMessage(message, arguments));
        this.logMessage = message;
        this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
    }

    public SafeIoException(@CompileTimeConstant String message, @Nullable Throwable cause, Arg<?> ... arguments) {
        super(SafeExceptions.renderMessage(message, arguments), cause);
        this.logMessage = message;
        this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
    }

    @Override
    public String getLogMessage() {
        return this.logMessage;
    }

    @Override
    public List<Arg<?>> getArgs() {
        return this.arguments;
    }
}

