/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe.logger;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.spi.SafeLoggerFactoryBridge;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;

public final class SafeLoggerFactory {
    private static final SafeLoggerFactoryBridge BRIDGE = ServiceLoader.load(SafeLoggerFactoryBridge.class, SafeLoggerFactory.class.getClassLoader()).stream().map(ServiceLoader.Provider::get).max(Comparator.comparing(SafeLoggerFactoryBridge::priority)).orElseThrow(NoSafeLoggerImplementationsException::new);

    public static SafeLogger get(@Safe Class<?> clazz) {
        return new SafeLogger(BRIDGE.get(clazz));
    }

    public static SafeLogger get(@Safe String name) {
        return new SafeLogger(BRIDGE.get(name));
    }

    private SafeLoggerFactory() {
    }

    private static final class NoSafeLoggerImplementationsException
    extends RuntimeException
    implements SafeLoggable {
        private static final String MESSAGE = "Unable to find any logsafe logger-spi implementations. Was the `logger-slf4j` dependency excluded?";

        NoSafeLoggerImplementationsException() {
            super(MESSAGE);
        }

        @Override
        public String getLogMessage() {
            return MESSAGE;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return Collections.emptyList();
        }
    }
}

